/*****************************************************************************
   MODULE: rputf.c
  PURPOSE: recio character delimited floating point output functions
COPYRIGHT: (C) 1994 William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.04
  RELEASE: October 10, 1994
*****************************************************************************/

#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern char *dtoa(double d, int dig, char *str);
extern int _rstatus(REC *rp, int mode);
extern int _rputc(REC *rp, int ch);

#define rfp(rp)          ((rp)->r_fp)
#define rcol(rp)         ((rp)->r_colno)
#define rfldch(rp)       ((rp)->r_fldch)
#define rflags(rp)       ((rp)->r_flags)

/****************************************************************************/
static void                  /* returns nothing                             */
    _rputd(                  /* output floating point number to rec stream  */
        REC *rp,             /* pointer to record stream                    */
        int dig,             /* number of significant digits                */
        double num)          /* floating point number                       */
/****************************************************************************/
{ 
    if (!_rstatus(rp, R_WRITE)) { 
        rfldno(rp)++; 
        rflags(rp) &= ~_R_TXT;

        /* if not first field, put field separator */
        if (rfldno(rp) > 1) { 
            if (_rputc(rp, rfldch(rp))) goto done; 
        } 

        /* convert number to string */
        dtoa(num, dig, _r_nsbuf); 

        /* output converted string */
        if (fputs(_r_nsbuf, rfp(rp)) != EOF) { 
            rcol(rp) += strlen(_r_nsbuf); 
        } else { 
            rseterr(rp, R_ENOPUT); 
        } 
    } 
done: 
}

/****************************************************************************/
/* character delimited floating point output functions                      */
/****************************************************************************/
void rputf(REC *rp, float num)
{
    _rputd(rp, FLT_DIG, (double) num);
}

void rputd(REC *rp, double num)
{
    _rputd(rp, DBL_DIG, num);
}
