//====================================================================
// Readrez.cpp
// Reads a previously created resource dialog
//====================================================================
#define Uses_TObject
#define Uses_TKeys
#define Uses_TApplication
#define Uses_TEvent
#define Uses_TRect
#define Uses_TDialog
#define Uses_TStaticText
#define Uses_TButton
#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_TStreamableClass
#define Uses_TResourceFile
#define Uses_TResourceCollection
#define Uses_MsgBox
#define Uses_fpstream

#include <tv.h>
#include <string.h>
#include <stdlib.h>

// #include <tprogbar.hpp>

// External links
__link ( RWindow )
__link ( RGroup )
__link ( RDialog )
__link ( RFrame )
__link ( RResourceCollection )
__link ( RCluster )
__link ( RButton )
// __link ( RProgressBar )

// Resource file name
const char rezFileName[] = "MY.REZ";

const cmAboutCmd = 100;             // About menu command
const cmStatusCmd = 101;            // Progress Bar menu

class MyApp: public TApplication {

    void aboutDialog();
//    void StatusDialog();
 //   Boolean isCancel (TDialog *p );

public:
    MyApp();
    static TMenuBar *initMenuBar (TRect);
    void handleEvent (TEvent&);

};

MyApp::MyApp () :TProgInit (&TApplication::initStatusLine,
                            &MyApp::initMenuBar,
                            &TApplication::initDeskTop )
{


}

//====================================================================
TMenuBar *MyApp::initMenuBar (TRect bounds )
{
    bounds.b.y = bounds.a.y+1;

    return ( new TMenuBar
           ( bounds,
 new TMenu (
*new TMenuItem ( "~A~bout", cmAboutCmd, kbAltA, hcNoContext, 0,
 new TMenuItem ( "~P~rogress Bar", cmStatusCmd, kbAltL, hcNoContext,0
               )
               )
               )
               )
               );
}

//====================================================================
void MyApp::handleEvent ( TEvent& event )
{
    TApplication::handleEvent (event );

    if ( event.what == evCommand ) {
        switch ( event.message.command ) {
            case cmAboutCmd:
                aboutDialog();
                break;
            case cmStatusCmd:
//                statusDialog();
                break;
            default:
                break;
        }
        clearEvent (event);
    }
}

void MyApp::aboutDialog()
{
    TDialog *pd = new TDialog (TRect(0, 0, 35, 12), "About");
    if (pd) {
        pd->options |= ofCentered;
        pd->insert (new TStaticText (TRect (1, 2, 34, 7),
                "\003T     V  Example\n\003\n"
                "\003Streaming a progress bar\n003\n" ));
        pd->insert (new TButton(TRect(3, 9, 32, 11), "~O~k", cmOK, bfDefault));

        if (validView(pd) != 0 ) {
            deskTop->execView(pd);
            destroy(pd);
        }
    }
}

int main()
{
    MyApp app;
    app.run();
    return 1;
}
