/* A simple user-interface demo -- Version 4 */

/* Written by Bernie Roehl, February 1992 */

/* Latest version (re)written June 1992 */

/* Contact: broehl@sunee.waterloo.edu */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>   /* toupper() */
#include <string.h>
#include <mem.h>     /* memmove() */
#include <dos.h>

#include "include/rend386.h"
#include "include/intmath.h"
#include "include/plg.h"
#include "include/segio.h"
#include "include/segasupp.h"
#include "include/splits.h"
#include "include/pointer.h"
#include "include/tasks.h"
#include "include/cursor.h"
#include "include/userint.h"

extern void *screen_data();

extern unsigned _stklen = 10000;

#define XFSC 536870912   /* 2**29 for shifting xform coeffs to long */

/* default screen data setup */

STEREO default_stereo = {
	600 , 240, 320, 50, 600, 1*65536L };

VIEW default_view = {
	0,0,-8000, /* ex,ey,ez */
	0,0,0, /* pan,tilt,roll */
	4*65536L, /* zoom */
	1000,15000,-5000, /* lx,ly,lz */
	0,63, /* point, ambient */
	0,319,0,200, /* left,right,top,bottom */
	1,100000, /* hither, yon */
	1/1.25*65536L, /* aspect ratio */
	0, /* flags */
	0,0, /* no offset */
	0 /* no flip */
}; /* don't init. matrix */

VIEW *current_view = &default_view;

VIEW orig_view; /* used for '*' key */

int v_page = 0; /* screen page swap variable */

OBJLIST *objlist; /* the linked list of objects in the scene */

int running = 1; /* non-zero until we're ready to exit */
int redraw = 1; /* non-zero if we need a redraw */
int review = 1; /* non-zero if we need to recompute current view */
int reframe = 1; /* non-zero if we need to copy our frame back on-screen */

int do_horizon = 1;

int stereo_type = MONOSCOPIC;

extern int use_old_keys; /* NEED TO SET DISTANCE AS WELL ! */

int have_joystick = 0; /* non-zero if we have one or more joysticks */
joystick_data joy;

long spacestep = 10L; /* "granularity" of motion */

unsigned lastkey = 0, nextolastkey = 0;

char *progname = "demo";

char vdname[40] = "vd256.rvd";
int vdmode = 0x14;

char swdname[40] = "sega";

char mdname[40] = "mouse";
PDRIVER *cursor_device = NULL; /* primary mouse device   */
PDRIVER *menu_device = NULL; /* secondary mouse device */
int manip_2D_avail = 0; /* can do mouse manipulation */

char gpdname[40] = "pglove";
char gpcursor[40] = "handsm.fig";
float gpdo_x = 1, gpdo_y = 1, gpdo_z = 2, gpdo_rx = 1, gpdo_ry = 1, gpdo_rz = 1;
int have_glove = 0;
int have_ptr = 0;
PDRIVER *manip_device = NULL; /* extended manip. device (glove or pointer) */

char hdname[40] = "none";
float hdo_x = 0, hdo_y = 0, hdo_z = 0; /* relative pos'n to neck */
float hdo_rx = 0, hdo_ry = 0, hdo_rz = 0;
PDRIVER *head_device = NULL; /* head tracking device   */


MATRIX head_tracker_map = { 
	XFSC, 0, 0, 0, XFSC, 0, 0, 0, XFSC, 0, 0, 0 };

int sl_xflip = 0, sl_xoff = 0;
long sl_left = -1, sl_top, sl_right, sl_bottom;
int sr_xflip = 0, sr_xoff = 0;
long sr_left = -1, sr_top, sr_right, sr_bottom;
float sl_xrot = 0, sr_xrot = 0;

int use_glove = 0;
int use_ht = 0;
int use_wide = 0;
int use_BW = 0;
int swap_eyes = 0;
int vd_loaded = 0;

int fancy_background = 0; /* if set, we display a fancy background */
int reflection_pool = 0; /* if set, draw a "reflecting pool" at the bottom of the screen */
int have_logo = 0; /* if set, we have a logo */
int show_logo = 0; /* if set, show the logo (if we have one) */
int show_location = 1; /* if set, we display the current location on-screen */
int show_compass = 1; /* if set, we display the 3-D compass on-screen */
int show_framerate = 1; /* if set, we display the frames/second rate */
int do_screen_clear = 1; /* by default, we clear the screen on each frame */
int use_frame = 0; /* if set, draw a "frame" */
int frame_x = 0, frame_y = 0, frame_w = 320, frame_h = 200; /* frame location */

TASK *tasklist = NULL;

SPLIT *split_tree = NULL;

int npalette = 0; /* non-zero if we have a palette loaded */
unsigned char palette[256*3];

extern unsigned getkey();

char framefname[100];

extern struct Screeninfo *screeninfo;
extern highest_color;

char loadpath[100] = "";

static char tempname[100];

char *fix_fname(char *name)
{
	if (loadpath[0] && !strchr(name, '\\') && !strchr(name, '/'))
		sprintf(tempname, "%s\\%s", loadpath, name);
	else
		strcpy(tempname, name);
	return tempname;
}

void *v_driver_pointer = NULL;

void load_video_driver(char *dfile)
{
	v_driver_pointer = load_driver(dfile);
	if (v_driver_pointer == NULL)
	{
		fprintf(stderr,"Cannot read video driver %s\n", dfile);
		exit(0);
	}
}

void main(int argc, char *argv[])
{
	OBJECT *obj;
	void wrap(); /* wrap-up function, shuts everything down */
	void joystick_calibration(), refresh_display();
	unsigned getkey();
	long x, y, z;
	FILE *in;
	int i;
	PDRIVER *dm;
	POINTER *p;
	char *fname;

	if ((progname = strrchr(argv[0], '.')) != NULL) *progname = '\0';
	progname = argv[0];

	if (getenv("REND386"))
		strcpy(loadpath, getenv("REND386"));

	setup_render(40,800); /* # of K, # of polys */
	atexit(wrap);
	set_global_split_root(&split_tree);
	initial_world_split(&split_tree);
	set_move_handler(split_move_handler);
	objlist = new_objlist();

	i = 1;
	if(!stricmp(&(argv[1][0]), "/C"))
	{
		i = 2;
		fname = &(argv[2][0]);
	}
	else fname = "rend386.cfg";

	if ((in = fopen(fname, "r")) == NULL)
		fprintf(stderr, "Note -- config file '%s' not found; using defaults.\n", fname);
	else
		{
		if (read_world(in))
			fprintf(stderr, "Error reading config file '%s'\n", fname);
		fclose(in);
	}

	for (; i < argc; ++i)
	{
		if (argv[i][0] == '/' || argv[i][0] == '-')
		{
			switch(toupper(argv[i][1]))
			{
			case 'M':/* mirror stereo */
				stereo_type = SPLITLR;
				/* possibly problem here: assumes 320x200 mode before checking */
				default_stereo.phys_screen_dist = 200;
				default_stereo.phys_convergence = 700;
				default_stereo.phys_screen_width = 120;
				default_stereo.pixel_width = 160;
				default_view.right = 159;
				compute_stereo_data(&default_stereo, 0, 0, 0, 0, 0, 0, 159, 100);
				compute_stereo_data(&default_stereo, 1, 1, 0, 0, 160, 0, 319, 100);
				break;
			case 'R':/* swap eyes on Sega driver */
				swap_eyes = 1;
				break;
			case 'C':/* set conv. distance */
				default_stereo.phys_screen_dist = atol(argv[++i]);
				break;
			case 'S':/* set world scale */
				default_stereo.world_scaling = 65536.0*atof(argv[++i]);
				break;
			case 'E':/* set eye spacing */
				default_stereo.phys_eye_spacing = atol(argv[++i]);
				break;
			case 'X':/* turn on stereo */
				stereo_type = SWITCHED;
				break;
			case 'J':/* sort by object (default is polys) */
				set_default_depth_sort(get_default_depth_sort() | BYOBJECT);
				break;
			case 'P':/* depth sort-- deepest */
				set_default_depth_sort(get_default_depth_sort() & (~(BYOBJECT|AVERAGE|ATBACK)));
				break;
			case 'A':/* depth sort-- middle */
				set_default_depth_sort(get_default_depth_sort() | AVERAGE);
				break;
			case '1':/* com 1 for SEGA */
				select_sega_port(0x3FC);
				break;
			case '2':/* com 2 for SEGA */
				select_sega_port(0x2FC);
				break;
			case 'G':/* enable glove */
				use_glove = 1;
				if(!have_ptr) have_glove = 1;
				break;
			case 'H':/* enable head tracker */
				use_ht = 1;
				break;
			case 'W':/* enable wide-angle dual-VGA displays */
				use_wide = 1;
				stereo_type = SEPARATE;
				default_stereo.phys_screen_dist = 50;
				default_stereo.phys_convergence = 1200;
				default_stereo.phys_screen_width = 115;
				default_stereo.pixel_width = 320; /* hmm... may vary */
				break;
			case 'B':/* force all colors to monochrome */
				use_BW = 1;
				break;
			}
		}
		else
			{
			char *in_filename;
			in_filename = fix_fname(argv[i]);
			if ((in = fopen(in_filename, "r")) == NULL)
				fprintf(stderr, "Could not open '%s'\n", in_filename);
			else
				if (strstr(in_filename,".plg")) /* check if plg or fig file */
			{
				set_loadplg_offset(0,0,0);
				set_loadplg_scale(1,1,1);
				while ((obj = load_plg(in)) != NULL)
				{
					SEGMENT *s;
					add_to_objlist(objlist, obj);
					if ((s = new_seg(NULL)) == NULL)
						fprintf(stderr, "Warning: out of memory while loading an object\n");
					else
						{
						seg_set_object(s, obj);
						set_object_owner(obj, s);
						update_segment(s);
					}
					if (spacestep < get_object_bounds(obj, &x, &y, &z)/5L)
						spacestep = get_object_bounds(obj, &x, &y, &z)/5L;
				}
				if (load_err)
				{
					fprintf(stderr, "Load error: %d\n", load_err);
					getkey();
				}
			}
			else if (strstr(in_filename,".fig")) /* check if plg or fig file */
			{
				SEGMENT *s;
				int c;
				set_readseg_objlist(objlist);
				if ((s = readseg(in, NULL)) == NULL)
					fprintf(stderr, "Could not read '%s'\n", argv[i]);
				else
					update_segment(s);
			}
			else {
				if (read_world(in))
					fprintf(stderr, "Error reading world file\n");
			}
			fclose(in);
		}
	}

	have_joystick = joystick_check();

	load_video_driver(vdname);
	screeninfo = screen_data();
	highest_color = screeninfo->colors-1;
	preset_default_colors();

	frame_x = screeninfo->xmin;
	frame_y = screeninfo->ymin;
	frame_w = screeninfo->xmax - screeninfo->xmin + 1;
	frame_h = screeninfo->ymax - screeninfo->ymin + 1;

	/* Default view is full-screen: */
	default_view.left = screeninfo->xmin;
	default_view.top = screeninfo->ymin;
	default_view.right = screeninfo->xmax;
	default_view.bottom = screeninfo->ymax;
	default_view.aspect = screeninfo->aspect;

	orig_view = default_view;

	if (enter_graphics())
	{
		fprintf(stderr, "Could not enter graphics mode\n");
		exit(1);
	}
	vd_loaded++;

	initialize_screen_factors(current_view);
	fast_view_factors(current_view);

	if (npalette)
		load_DAC_colors(palette, highest_color+1, use_BW);

	if (use_frame)
	{
		FILE *in;
		use_frame = 0; /* we only set it back to 1 if we're successful */
		if(stereo_type == MONOSCOPIC)
			if ((in = fopen(fix_fname(framefname), "rb")) != NULL)
			{
				if (load_pcx(in, 3) == 0) use_frame = 1;
				copy_block(3, 0, 0, 0, frame_x, frame_y, frame_w, frame_h);
				copy_block(3, 0, 0, 1, frame_x, frame_y, frame_w, frame_h);
				copy_block(3, 0, 0, 2, frame_x, frame_y, frame_w, frame_h);
				fclose(in);
			}
	}

	init_body_links();

	if(stereo_type != MONOSCOPIC)
	{
		init_switch_driver(swdname);

		if(sl_left<0)
		{
			sl_left = default_view.left;
			sl_right = default_view.right;
			sl_top = default_view.top;
			sl_bottom = default_view.bottom;
		}
		compute_stereo_data(&default_stereo, 0, sl_xflip, sl_xoff, 65536.0*sl_xrot,
		sl_left, sl_top, sl_right, sl_bottom);

		if(sr_left<0)
		{
			sr_left = default_view.left;
			sr_right = default_view.right;
			sr_top = default_view.top;
			sr_bottom = default_view.bottom;
		}
		compute_stereo_data(&default_stereo, 1, sr_xflip, sr_xoff, 65536.0*sr_xrot,
		sr_left, sr_top, sr_right, sr_bottom);
	}

	if ((dm=mouseptr_init(mdname))!=NULL)
	{
		cursor_show(v_page);
		manip_2D_avail++;
	}
	cursor_device = dm;
	menu_device = dm;

	if(stricmp(hdname,"none") && use_ht)
	{
		extern PDRIVER *init_head_device(char *name, long x, long y, long z, long rx, long ry, long rz);
		head_device = init_head_device(hdname, hdo_x, hdo_y, hdo_z,
		hdo_rx*65536.0, hdo_ry*65536.0, hdo_rz*65536.0);
	}

	if ((!use_glove) || have_ptr || stricmp(gpdname,"pglove")) /* not going to be using powerglove */
	{
		if(stereo_type==SWITCHED)
			init_SG_interrupt(switch_sega,NULL,6500);
		else init_timer();
	}

	if(use_glove && (!have_ptr))
	{
		extern SEGMENT *body_seg;
		PDRIVER *gd;
		extern PDRIVER *gloveptr_init(char *gname, long sx, long sy, long sz, long srx, long sry, long srz);

		gd = gloveptr_init(gpdname, gpdo_x*65536.0, gpdo_y*65536.0, gpdo_z*65536.0,
		gpdo_rx*65536.0, gpdo_ry*65536.0, gpdo_rz*65536.0);
		manip_device = menu_device = gd;
		if(gd)
			load_glove_cursor(body_seg, manip_device, gpcursor);
		else have_glove = use_glove = 0;
	}

	if(use_glove && have_ptr)
	{
		extern SEGMENT *body_seg;
		PDRIVER *gd;
		extern PDRIVER *gloveptr_init(char *gname, long sx, long sy, long sz, long srx, long sry, long srz);

		gd = gloveptr_init(gpdname, gpdo_x*65536.0, gpdo_y*65536.0, gpdo_z*65536.0,
		gpdo_rx*65536.0, gpdo_ry*65536.0, gpdo_rz*65536.0);
		manip_device = menu_device = gd;
		if(gd)
		{
			set_loadplg_offset(0, 0, 0);
			set_loadplg_scale(1, 1, 1);
			load_3D_cursor(body_seg, manip_device, gpcursor);
		}
		else have_ptr = use_glove = 0;
	}

	if ((have_joystick) != 0)
	{
#ifdef ASKUSER
		popmsg("Joystick found -- use it?");
		reframe = 1;
		joystick_read(&joy);
		while(!kbhit() && (joy.buttons==0)) joystick_read(&joy);
		if(joy.buttons || toupper(getkey()) == 'Y')
		{
			refresh_display();
			joystick_calibration(&joy);
		}
		else
			have_joystick = 0;
		refresh_display();
#else
		joystick_calibration(&joy);
#endif
	}

	while (running)
	{
		int x, y;
		unsigned buttons;

		if (cursor_device) move_and_select_2D(cursor_device);

		if (have_joystick)
			if (joystick_read(&joy))
				do_joy(&joy);
		if (bioskey(1))
		{
			do_key(nextolastkey = getkey());
			lastkey = nextolastkey;
		}

		if(head_device && use_ht) head_update(0);

		if (use_glove)
		{
			POINTER gp;
			int g;

			if(!have_ptr)
			{
				glove_update(manip_device, &gp);
				switch(gp.gesture)
				{
				case G_FIST :
					g = GRASP_DO; 
					break;
				case G_PINCH:
					g = ROTATE_DO; 
					break;
				case G_POINT:
					g = SELECT_DO; 
					break;
				default:
					g = FREE_DO; 
					break;
				}
			}
			else
				{
				cursor_update3D(manip_device, &gp);
				switch(gp.buttons)
				{
				case 2:
					g = GRASP_DO; 
					break;
				case 3:
					g = ROTATE_DO; 
					break;
				case 1:
					g = SELECT_DO; 
					break;
				default:
					g = FREE_DO; 
					break;
				}
			}

			manip_do(manip_device,g);
		}

		run_tasks(tasklist);

		if (redraw) refresh_display();
	}
}


static char *closing_msg[] = {
	"",
	"The libraries used in this package are available on the Internet,",
	"via anonymous ftp to sunee.uwaterloo.ca in pub/rend386.",
	"",
	"For more information, send e-mail to:",
	"    Bernie Roehl  (broehl@sunee.uwaterloo.ca)",
	"    Dave Stampe   (dstampe@sunee.uwaterloo.ca)",
	"",
	NULL};


void wrap() /* end program */
{
	int i;

	if (have_joystick) joystick_quit();
	if(vd_loaded) exit_graphics();
	reset_render();
	for (i = 0; closing_msg[i]; ++i)
		fprintf(stderr, "%s\n", closing_msg[i]);
	exit(0);
}



static l_x = 1000, l_y = 15000, l_z = -5000; /* light source */

long center_d = 10000;
long center_x = 0;
long center_y = 0;
long center_z = 0;
long latitude = 0;
long longitude = 0;
long center_roll = 0;

static long light_d = 1000000;

void polar_compute()
{
	MATRIX m,n;

	long x = 0;
	long y = 0;
	long z = -center_d;

	std_matrix(n,longitude,latitude,center_roll,0,0,0);

	matrix_point(n,&x,&y,&z);
	current_view->ex = x + center_x;
	current_view->ey = y + center_y;
	current_view->ez = z + center_z;

	x = l_x;
	y = l_y; 
	z = l_z;
	matrix_point(n,&x,&y,&z);
	current_view->lx = x;
	current_view->ly = y;
	current_view->lz = z;
	current_view->pan = latitude;
	current_view->tilt = longitude;
	current_view->roll = center_roll;
}


void refresh_display()
{
	VIEW v;

	if (use_old_keys) polar_compute();
	initialize_screen_factors(current_view);

	if(!(use_glove || head_device))
	{
		fast_view_factors(current_view);
		screen_refresh(current_view);
	}
	else
		{
		body_centric_map(current_view, &v);
		screen_refresh(&v);
	}

	redraw = 0;
}



load_logo(char *filename)
{
	char far *buffer;
	FILE *in;
	if ((in = fopen(fix_fname(filename), "rb")) == NULL) return 0;
	if (load_pcx(in, 3)) { /* some sort of problem loading it in */
		fclose(in);
		return 0;
	}
	fclose(in);
	return 1; /* all is well... we have a logo */
}

resize_viewport()
{
	int top, left, bottom, right;
	unsigned buttons;
	cursor_hide();
	clear_display(v_page);
	cursor_show(v_page);
	popmsg("Click top-left and drag");
	do {
		move_2D(cursor_device, &left, &top, &buttons);
	}
	while (buttons == 0);
	while (buttons) {
		while (!move_2D(cursor_device, &right, &bottom, &buttons));
		clear_display(v_page);
		vgabox(left, top, right, bottom, 15);
	}
	if (right - left > 10) {
		current_view->left = left & (~0x0007); /* always on a 16-pixel boundary */
		current_view->right = (right & (~0x0007)) + 7;
	}
	if (bottom - top > 10) {
		current_view->top = top;
		current_view->bottom = bottom;
	}

 if(stereo_type == SWITCHED)  /* makes sense for Sega only (no shift) */
	{
		compute_stereo_data(&default_stereo, 0, sl_xflip, sl_xoff, 65536.0*sl_xrot,
		current_view->left, current_view->top, current_view->right, current_view->bottom);
		compute_stereo_data(&default_stereo, 1, sr_xflip, sr_xoff, 65536.0*sr_xrot,
		current_view->left, current_view->top, current_view->right, current_view->bottom);
	}

	/* Make sure all pages are refreshed: */
	reset_screens();
	refresh_display();
	return 0;
}

save_pcx_file()
{
	char filename[100];
	char far *buffer;
	FILE *out;
	refresh_display();
	askfor("File to save to? ", filename, 15);
	reframe = 1;
	if (filename[0] == '\0') return 1;
	refresh_display();
	if ((out = fopen(filename, "wb")) == NULL) {
		popmsg("Could not open file");
		reframe = 1;
		getkey();
		return 3;
	}
	cursor_hide();
	save_pcx(out, v_page);
	cursor_show(v_page);
	fclose(out);
	return 0;
}

/* Some support routines */

static void center(char *s, int w)
{
	int n;

	if (strlen(s) == 0) return;
	n = (w - strlen(s)) /2;
	memmove(&s[n], s, strlen(s)+1);
	memset(s, ' ', n);
}

disp_status(VIEW *v)
{
	char *text[9], a[80], b[80], c[80], d[80], e[80], f[80], g[80];
	int w, i;

	text[0] = a; 
	text[1] = "";
	text[2] = b; 
	text[3] = c; 
	text[4] = d; 
	text[5] = e; 
	text[6] = f;
	text[7] = g; 
	text[8] = NULL;
	sprintf(a, "STATUS");

	sprintf(b, "X = %ld  Y = %ld  Z = %ld", v->ex, v->ey, v->ez);
	w = strlen(b);
	sprintf(c, "Pan = %ld   Tilt = %ld   Roll = %ld  ", v->pan/65536L, v->tilt/65536L, v->roll/65536L);
	if (strlen(c) > w) w = strlen(c);
	sprintf(d, "Zoom = %ld", v->zoom/65536L);
	if (strlen(d) > w) w = strlen(d);
	sprintf(e, "Hither = %ld  Yon = %ld", v->hither, v->yon);
	if (strlen(e) > w) w = strlen(e);

	if (have_joystick)
	{
		joystick_read(&joy);
		sprintf(f, "Joystick = %d,%d", joy.x, joy.y);
		if (strlen(f) > w) w = strlen(f);
	}
	else
		text[6] = NULL;
	text[7] = NULL;

	for (i = 0; text[i]; ++i) center(text[i], w);
	poptext(text);
	reframe = 1;
	getkey();
	return 0;
}


void joystick_calibration(joystick_data *joy)
{
	if (have_joystick == 0) return;
	if (have_joystick & 1) joystick_init(joy, 0);
	else if (have_joystick & 2) joystick_init(joy, 1);

	joystick_setscale(joy, 100);
	reframe = 1;
}

static int nobjs, nverts, npolys;

void gather_data(OBJECT *obj)
{
	int nv = 0, np = 0;
	get_obj_info(obj, &nv, &np);
	++nobjs;
	nverts += nv;
	npolys += np;
}

disp_info()
{
	OBJECT *obj;
	char buff[100];
	nobjs = 0, nverts = 0, npolys = 0;

	walk_split_tree(split_tree, gather_data);
	sprintf(buff, "%d object%s, %d vertice%s, %d polygon%s", nobjs,
	(nobjs == 1) ? "" : "s", nverts, (nverts == 1) ? "" : "s",
	npolys, (npolys == 1) ? "" : "s");
	popmsg(buff);
	reframe = 1;
	getkey();
	return 0;
}

extern AREA *areas;

extern POINTER gloveptr;

char *gest[] = {
	"FLAT", "THUMB_IN", "INDEX_IN", "MIDDLE_IN",
	"RING_IN", "PINCH", "FIST", "THUMB_OUT", "POINT",
	"BADFINGER", "RING_OUT", "??????" };

void prprint(int x,int y, int color, char *t)
{
	int bk = (color>8) ? 0 : 15;

	printxyr(x,y,bk,t,0);
	printxyr(x+1,y+1,color,t,0);
}

status_on_screen()
{
	char buff[100];
	AREA *a, *what_area();
	long floor_at(), ceiling_at();
	extern void *find_value();

	if (show_location == 0) return 0;

	sprintf(buff, "Pos(x,z): %ld,%ld", current_view->ex, current_view->ez);
	prprint(2,3,15,buff);
	sprintf(buff, "Not in any area");
	a = what_area(split_tree, current_view->ex, current_view->ey, current_view->ez);
	if (a)
	{
		char *p = find_value(areas, a);
		if (p)
			sprintf(buff, "Area: %s", p);
	}
	prprint(2,15,15,buff);

	if (use_glove)
	{
		int sl;
		POINTER p;

		last_pointer(manip_device, &p);
		sprintf(buff,"Glove: %s",gest[p.gesture]);
		sl = strlen(buff)<<3;
		prprint(300-sl,3,15,buff);
	}
	return 0;

}

