/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                           *
 *                                                                           *
 Program : QCLIENT.C
 Date    : 05/20/91
 Function: QCLIENT submits jobs to a queue.
 Genesis : Turbo C 2.0
           Compiled in Turbo C environment with defaults under DOS 3.3.

 This software is provided as is and carries no warranty
 whatsoever.  Novell disclaims and excludes any and all implied
 warranties of merchantability, title and fitness for a particular
 purpose.  Novell does not warrant that the software will satisfy
 your requirements or that the software is without defect or error
 or that operation of the software will be uninterrupted.  You are
 using the software at your risk.  The software is not a product
 of Novell, Inc. or any of subsidiaries.
 *                                                                           *
 *                                                                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <string.h>
#include <io.h>
#include <nit.h>
#include <niterror.h>
#include <nitq.h>

#define INT21 0x21
#define OT_TEST_SERVER   0x8010
#define OT_TEST_QUEUE    0x8020

void main (void);

char writeBuf[14] = "This is a test" ;
JobStruct job;

void main() {
    int  cCode, NETQfileHandle, sizeWritten;
    long queueID, serverID;

    if (cCode = GetBinderyObjectID ("CHRIS_QUEUE",
                                    OT_TEST_QUEUE,
                                    &queueID))
      printf ("\nError %d getting bindery object ID.", cCode);
    if (cCode = GetBinderyObjectID ("CHRIS_SERVER",
                                    OT_TEST_SERVER,
                                    &serverID))
      printf ("\nError %d getting bindery object ID.", cCode);
    job.targetServerIDNumber = serverID;
    memset (job.targetExecutionTime, 0xFF, sizeof (job.targetExecutionTime));
    job.jobType = 0x0045;
    job.jobControlFlags = QF_AUTO_START;
    if (cCode = CreateQueueJobAndFile (queueID,
                                       &job,
                                       &NETQfileHandle))
      printf ("\nError %d creating queue job and file.", cCode);
    sizeWritten = write (NETQfileHandle,
                         writeBuf, sizeof (writeBuf));
    if (sizeWritten != sizeof (writeBuf)) {
      printf ("\nError writing data buffer.");
      if (cCode = CloseFileAndAbortQueueJob (queueID,
                                             job.jobNumber,
                                             NETQfileHandle))
        printf ("\nError %d closing and aborting queue job.", cCode);
      }
    else
      if (cCode = CloseFileAndStartQueueJob (queueID,
                                             job.jobNumber,
                                             NETQfileHandle))
        printf ("\nError %d closing and starting queue job.", cCode);
}

