/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                           *
 *                                                                           *
 Program : QSERVER.C
 Date    : 05/20/91
 Function: QSERVER services a queue.
 Genesis : Turbo C 2.0
           Compiled in Turbo C environment with defaults under DOS 3.3.
 
 This software is provided as is and carries no warranty
 whatsoever.  Novell disclaims and excludes any and all implied
 warranties of merchantability, title and fitness for a particular
 purpose.  Novell does not warrant that the software will satisfy
 your requirements or that the software is without defect or error
 or that operation of the software will be uninterrupted.  You are
 using the software at your risk.  The software is not a product
 of Novell, Inc. or any of subsidiaries.
 *                                                                           *
 *                                                                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <nit.h>
#include <niterror.h>
#include <nitq.h>

#define OT_TEST_SERVER 0x8010
#define OT_TEST_QUEUE  0x8020
#define NO_CHARGE 0L
#define IOERROR   -1
char readBuf[20];

main()
{
    long queueID;
    long charge = 0;
    int  cCode, errno;
    int  fileHandle;
    int  readResult;
    WORD conID;
    WORD jobType = 0x0045;
    WORD jobCount;
    BYTE directoryHandle;
    BYTE drive;
    BYTE statFlag;
    JobStruct job;
    char fileServer[48], QServer[48];

    strcpy (QServer, "CHRIS_SERVER");
   cCode = LoginToFileServer (QServer, OT_TEST_SERVER, "CHRISERVER");
   if(cCode != 0) {
      printf("\nError in LoginToFileServer.  Status = %d",cCode);
      exit(1);
   }
   printf("\n%s successfully logged into server.", QServer);

    queueID=-1;
    if (cCode = GetBinderyObjectID ("CHRIS_QUEUE",
                                    OT_TEST_QUEUE,
                                    &queueID)) {
      printf ("\nError %d getting bindery object ID.", cCode);
      exit (1);
      }
    if (cCode = AttachQueueServerToQueue (queueID))
      printf ("\nError %d attaching queue server to queue.", cCode);
    job.serverIDNumber = 0x00;
    if (cCode = ServiceQueueJobAndOpenFile (queueID,
                                            jobType,
                                            &job,
                                            &fileHandle))
      printf ("\nError %d servicing queue job.", cCode);
    readResult = read (fileHandle, readBuf, sizeof (readBuf));
    if (readResult==IOERROR)
      printf ("\nError %d occured on read.", errno);
    else
      printf ("\nIncoming!:%s.", readBuf);
    if (cCode = FinishServicingQueueJobAndFile (queueID,
                                                job.jobNumber,
                                                NO_CHARGE,
                                                fileHandle))
      printf ("\nError %d finishing servicing queue job and file.", cCode);
    if (cCode = DetachQueueServerFromQueue (queueID))
      printf ("\nError %d detaching queue server from queue.", cCode);
}

