/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                           *
 *                                                                           *
 Program : DESTROYQ.C
 Date    : 05/20/91
 Function: DESTROYQ destroys a queue created with CREATQ.
 Genesis : Turbo C 2.0
           Compiled in Turbo C environment with defaults under DOS 3.3.

 This software is provided as is and carries no warranty
 whatsoever.  Novell disclaims and excludes any and all implied
 warranties of merchantability, title and fitness for a particular
 purpose.  Novell does not warrant that the software will satisfy
 your requirements or that the software is without defect or error
 or that operation of the software will be uninterrupted.  You are
 using the software at your risk.  The software is not a product
 of Novell, Inc. or any of subsidiaries.
 *                                                                           *
 *                                                                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <dos.h>
#include <nit.h>
#include <niterror.h>
#include <nitq.h>

#define INT21          0x21
#define OT_TEST_SERVER 0x8010
#define OT_TEST_QUEUE  0x8020

char GetCurrentDrive (void);
void main (void);

void main() {
    int  cCode;
    long queueID;
    BYTE drive ;
    BYTE dirHandle;

    drive = GetCurrentDrive() ;
    dirHandle = GetDirectoryHandle (drive);
    if (cCode = GetBinderyObjectID ("CHRIS_QUEUE",
                                    OT_TEST_QUEUE,
                                    &queueID)) {
      printf ("\nError %d getting bindery object ID.", cCode);
      exit (1);
      }
    if (cCode = DestroyQueue (queueID)) {
      printf ("\nError %d destroying queue.", cCode);
      exit (1);
      }
     else printf ("\nQueue destroyed.");
    if (cCode = DeleteBinderyObject ("CHRIS_SERVER",
                                     OT_TEST_SERVER))
      printf ("\nError %d deleting bindery object.", cCode);
    else printf ("\nBindery object deleted.");
}

char GetCurrentDrive()
{
    union REGS reg ;
    struct SREGS segs ;

    reg.h.ah = 0x19 ;
    int86x(INT21,&reg,&reg,&segs) ;
    return(reg.h.al) ;
}
