/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                           *
 *                                                                           *
 Program : CREATQ.C
 Date    : 05/20/91
 Function: CREATQ creates a queue on the current server.
 Genesis : Turbo C 2.0
           Compiled in Turbo C environment with defaults under DOS 3.3.

 This software is provided as is and carries no warranty
 whatsoever.  Novell disclaims and excludes any and all implied
 warranties of merchantability, title and fitness for a particular
 purpose.  Novell does not warrant that the software will satisfy
 your requirements or that the software is without defect or error
 or that operation of the software will be uninterrupted.  You are
 using the software at your risk.  The software is not a product
 of Novell, Inc. or any of subsidiaries.
 *                                                                           *
 *                                                                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <nit.h>
#include <niterror.h>
#include <nitq.h>

#define INT21            0x21
#define OT_TEST_SERVER   0x8010
#define OT_TEST_QUEUE    0x8020
#define SEGMENT1         0x01
#define NO_MORE_SEGMENTS 0x00

char GetCurrentDrive (void) ;
void main (void);

struct {
    BYTE accountExpirationDate[3] ;
    BYTE accountDisabledFlag ;
    BYTE passwordExpirationDate[3] ;
    BYTE graceLogin ;
    WORD passwordExpirationIntervals ;
    BYTE graceLoginResetValue ;
    BYTE minPasswordLength ;
    WORD maxConcurrentConnections ;    
    BYTE allowedLoginTimeBitmap[42] ;
    BYTE lastLoginDateTime[6] ;
    BYTE restrictionFlags ;
    BYTE unused ;
    long maxDiskUsageInBlocks ;
    WORD badLoginCount ;
    long nextResetTime ;
    BYTE badLoginAddr[12] ;
} loginControl;

void main(void) {
    int  cCode;
    long queueID;
    BYTE drive ;
    BYTE statusFlags;
    BYTE dirHandle;
    WORD fileServerConnectionID;

    drive = GetCurrentDrive() ;
    statusFlags = GetDriveInformation (drive,
                                       &fileServerConnectionID,
                                       &dirHandle);

  if (cCode = CreateBinderyObject ("CHRIS_SERVER",
                                   OT_TEST_SERVER,
                                   BF_STATIC,
                                   BS_ANY_READ|BS_ANY_WRITE))
    printf ("\nError Creating Object.  Error: %d\n", cCode);
  else
    printf ("\nObject Created.");
  if (cCode = ChangeBinderyObjectPassword ("CHRIS_SERVER",
                                           OT_TEST_SERVER,
                                           "",
                                           "CHRISERVER"))
     printf ("\nError Changing Password.  Error: %d\n", cCode);
  else
    printf ("\nPassword Created.");
  if (cCode = CreateProperty ("CHRIS_SERVER",
                              OT_TEST_SERVER,
                              "LOGIN_CONTROL",
                              BF_STATIC|BF_ITEM,
                              BS_OBJECT_READ|BS_OBJECT_WRITE))
     printf ("\nError Creating Property.  Error: %d\n", cCode);
  else
    printf ("\nProperty Created.");
  memset (loginControl.allowedLoginTimeBitmap, 0xFF,
          sizeof (loginControl.allowedLoginTimeBitmap));
  loginControl.minPasswordLength=5;
  if (cCode = WritePropertyValue ("CHRIS_SERVER",
                                  OT_TEST_SERVER,
                                  "LOGIN_CONTROL",
                                  SEGMENT1,
                                  (BYTE *)&loginControl,
                                  NO_MORE_SEGMENTS))
    printf ("\nError Writing Property Value.  Error: %d\n", cCode);
  else printf ("\nProperty Written.");
  if (cCode = CreateProperty ("CHRIS_SERVER",
                              OT_TEST_SERVER,
                              "SECURITY_EQUALS",
                              BF_STATIC|BF_SET,
                              BS_OBJECT_READ|BS_OBJECT_WRITE))
     printf ("\nError Creating Property.  Error: %d\n", cCode);
  else printf ("\nProperty Created.");
  if (cCode = AddBinderyObjectToSet ("CHRIS_SERVER",
                                     OT_TEST_SERVER,
                                     "SECURITY_EQUALS",
                                     "SUPERVISOR",
                                     OT_USER))
     printf ("\nError Adding to Set.  Error: %d\n", cCode);
  else printf ("\nObject Added to Set.");
  if (cCode = AddBinderyObjectToSet ("CHRIS_SERVER",
                                     OT_TEST_SERVER,
                                     "SECURITY_EQUALS",
                                     "EVERYONE",
                                     OT_USER_GROUP))
     printf ("\nError Adding to Set.  Error: %d\n", cCode);
  else printf ("\nObject Added to Set.");

  if (cCode = CreateQueue ("CHRIS_QUEUE",
                           OT_TEST_QUEUE,
                           dirHandle,
                           "",
                           &queueID))
    printf ("\nError %d creating queue", cCode);
  else printf ("\nQueue created.");

  if (cCode = AddBinderyObjectToSet ("CHRIS_QUEUE",
                                     OT_TEST_QUEUE,
                                     "Q_USERS",
                                     "COJEDA",
                                     OT_USER))
     printf ("\nError Adding to Set.  Error: %d\n", cCode);
  else printf ("\nObject Added to Set.");

  if (cCode = AddBinderyObjectToSet ("CHRIS_QUEUE",
                                     OT_TEST_QUEUE,
                                     "Q_OPERATORS",
                                     "COJEDA",
                                     OT_USER))
     printf ("\nError Adding to Set.  Error: %d\n", cCode);
  else printf ("\nObject Added to Set.");

  if (cCode = AddBinderyObjectToSet ("CHRIS_QUEUE",
                                     OT_TEST_QUEUE,
                                     "Q_SERVERS",
                                     "CHRIS_SERVER",
                                     OT_TEST_SERVER))
     printf ("\nError Adding to Set.  Error: %d\n", cCode);
  else printf ("\nObject Added to Set.");
}

char GetCurrentDrive () {
    union REGS reg ;
    struct SREGS segs ;

    reg.h.ah = 0x19 ;
    int86x(INT21,&reg,&reg,&segs) ;
    return(reg.h.al) ;
}
