/*---------------------------------------------------------------------------
 |  Module DEMO.C                                                           |
 |                                                                          |
 |  This module illustrates examples of QCHRT usage.  Both inline and       |
 |  subroutine timing techniques are shown.                                 |
 |                                                                          |
 |  (c)1988 by Ryle Design, P.O. Box 22, Mt. Pleasant, Michigan 48804       |
 |                                                                          |
 |  Development history                                                     |
 |  -------------------                                                     |
 |  V1.00  6.07.88  Initial distribution                                    |
 ---------------------------------------------------------------------------*/

#include <stdio.h>
#include <math.h>
#include "qchrt.h"


double  alpha = 3.14159;
double  beta  = 0.0;


void do_it(double *alpha, double *beta);


void main(void)
{
    int     indx;

    /* initialize QCHRT primitives before anything else */

    t_start();

    /* then calibrate QCHRT before first timer is activated */

    t_calib();

    /* turn on first timer to time total run time of application under test */

    t_entry(0);

    /* normal application code would start here */

    printf("QCHRT demo executing\n");

    /* place a timer inside for loop */

    for (indx=0; indx < 1000; indx++)
    {
        t_entry(1);
        beta *= alpha;
        alpha += beta;
        t_exit(1);
    }

    /* now call a subroutine that we have a timer
       in to compare inline vs. subroutine times  */

    for (indx=0; indx<1000; indx++) do_it(&alpha,&beta);

    /* all done with application code.  Stop timer to get run time */

    t_exit(0);

    /* shut down QCHRT primitives */

    t_stop();

    /* annotate the profile summary */

    t_name(0,"Total run time");
    t_name(1,"Inline code");
    t_name(2,"Subroutine code");

    /* now generate report on CRT - could go to disk or printer also */

    t_report(0);

    /* all done */

} /* main */


void do_it(double *alpha, double *beta)
/*
    Here we see how to time a subroutine.  QCHRT will tell us how many
    times this routine is called, how much total time spent here, and
    the average time spent here each time the routine was invoked.

    Note that since the timers are INSIDE the subroutine, the overhead
    involved with invoking the subroutine will not be reflected in the
    timing result.  A better way to time a subroutine to account for
    the calling overhead would be like this:

          for (indx=0; indx<1000; indx++)
          {
            t_entry(2);
            do_it(&alpha,&beta);
            t_exit(2)
          }

*/
{
    /* start a timer */

    t_entry(2);

    /* do what we came here to do */

    *beta *= *alpha;
    *alpha += *beta;

    /* stop timer */

    t_exit(2);

} /* do_it */
