#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TBackground
#define Uses_TButton
#define Uses_TKeys
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TListBox
#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TScrollBar
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TStringCollection
#define Uses_TCollection
#define Uses_TNSCollection
#define Uses_TInputLine
#include <tv.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pxengine.h>

#define TABLE "track"

char *fields[] =
{
  "File name",
  "Access count",
  "Last access"
};

FIELDHANDLE keyfields[] =
{
  1
};

FIELDHANDLE datefields[] =
{
  3
};


char *types[] =
{
  "A64",
  "N",
  "D"
};

struct REC : public TObject
{
  RECORDNUMBER n;
  REC (RECORDNUMBER r) : n (r){}
  };


void PXError (int x, char *file, long line);

#define pe(x) PXError (x, __FILE__, __LINE__)

void PXError (int x, char *file, long line)
{

  if (x != PXSUCCESS)
  {
    printf ("\nEngine Error # %d on line %ld in %s\n"
            "Engine reports: %s\n", x, line, file, PXErrMsg (x));
    exit (-1);
  }
}

//========================================================================
//  global data
//------------------------------------------------------------------------
const cmAbout   = 100;  // User selected menu item 'About'
const cmList    = 101;  // User selected menu item 'List'
const cmMyNotification = 1001;
const cmMyNotification2 = 1002;
const cmMyValidation   = 1003;
#define cpColor1 "\x31\x1E\x6E\x1B\x0E\x6E"

//========================================================================
//  class definitions
//------------------------------------------------------------------------
class TApp : public TApplication {
    //  main application class

public:
    TApp();

    // virtual functions to be locally redefined
    static TMenuBar *initMenuBar( TRect r );
    void handleEvent( TEvent &event );

    // declare new functions
    void AboutDialog();
    void ListDialog();
};


extern unsigned char shadowAttr;
//========================================================================
//  implementation of TApp
//------------------------------------------------------------------------
TApp::TApp() : TProgInit( &TApplication::initStatusLine,
                    &TApp::initMenuBar, &TApplication::initDeskTop )
{
    // default status line and desk top


/*
    TPalette &r = TProgram::getPalette ();

    strncpy (&r.data[1], cpColor1,7);

    menuBar->drawView();
    statusLine->drawView();
    shadowAttr = 0x03;
*/
}

//------------------------------------------------------------------------
// define menu bar
//------------------------------------------------------------------------
TMenuBar *TApp::initMenuBar( TRect r )
{
    r.b.y = r.a.y + 1;
    return( new TMenuBar( r, new TMenu(
        *new TMenuItem( "~A~bout", cmAbout, kbAltA, hcNoContext, 0,
        new TMenuItem( "~L~ist", cmList, kbAltL, hcNoContext, 0 )
        ) ) ) );
}

//------------------------------------------------------------------------
// event-handler
//------------------------------------------------------------------------
void TApp::handleEvent( TEvent &event )
{
    TApplication::handleEvent( event );
    if( event.what == evCommand )
    {
        switch( event.message.command )
        {
            case cmAbout:       // display the about box
                AboutDialog();
                clearEvent( event );
                break;
            case cmList:        // display our list box
                ListDialog();
                clearEvent( event );
                break;
        }
    }
}

//------------------------------------------------------------------------
// create modal About dialog box
//------------------------------------------------------------------------
void TApp::AboutDialog()
{
    // the About box reminds the user what is being demonstrated
    TDialog *pd = new TDialog( TRect( 0, 0, 35, 12 ), "About" );
    if( pd )
    {
        pd->options |= ofCentered;
        pd->insert( new TStaticText( TRect( 1, 2, 34, 7 ),
                "\003Turbo Vision Example\n\003\n"
                "\003Creating a TListBox\n\003\n"
                "\003Borland Technical Support" ) );
        pd->insert( new TButton( TRect( 3, 9, 32, 11 ), "~O~k",
                                cmOK, bfDefault ) );
        deskTop->execView( pd );
    }
    destroy( pd );
}


class TRecCollection : public TSortedCollection
{
  public:
  int def;
  FIELDHANDLE sort;
  TABLEHANDLE hand;


  TRecCollection (ushort a, ushort b) : TSortedCollection (a,b),
                                        def (1),
                                        sort (1),
                                        hand (0)
  {
  }

  virtual int compare( void *key1, void *key2 )
  {
     REC *p1, *p2;
     RECORDHANDLE rec;

     TDATE date1, date2;

//     return 1;

     int ret = 1;

     if (hand == 0)
       return 1;

     p1 = (REC *) key1;
     p2 = (REC *) key2;

     pe (PXRecBufOpen (hand, &rec));

     if (PXRecGoto (hand, p1->n) == PXSUCCESS)
     {
       pe (PXRecGet (hand, rec));
       pe (PXGetDate (rec, sort, &date1));
     }

     if (PXRecGoto (hand, p2->n) == PXSUCCESS)
     {
       pe (PXRecGet (hand, rec));
       pe (PXGetDate (rec, sort, &date2));
     }

     if ((unsigned long)date1 < (unsigned long)date2)
       ret = 1;
     else
       ret = -1;

     pe (PXRecBufClose (rec));
     return ret;
  }
  void writeItem( void *obj, opstream& os )
  {
      os.writeString( (const char *)obj );
  }
  void *readItem( ipstream& is )
  {
      return is.readString();
  }
};


class TTableDialog : public TDialog
{
  public:
  TListBox *lb;

  TABLEHANDLE handle;
  RECORDHANDLE rec;


  TTableDialog (TRect &r, char *name): TDialog (r, name), TWindowInit( initFrame )
  {
    lb = NULL;
    pe (PXInit ());
    pe ((PXTblOpen (TABLE, &handle, 0,0)));
    PXRecBufOpen (handle, &rec);
  }

  void Init (TListBox *p)
  {
    RECORDNUMBER num = 0;
    lb = p;
    pe (PXRecFirst (handle));

    ((TRecCollection *)lb->list())->hand = handle;
    ((TRecCollection *)lb->list())->sort = 3;

    do
    {
      pe (PXRecNum (handle, &num));
      lb->list()->insert(new REC(num));
      lb->setRange(lb->range+1);
    }
    while (!PXRecNext (handle));
  }

  ~TTableDialog ()
  {
    pe (PXRecBufClose (rec));
    pe (PXTblClose (handle));
    pe (PXExit ());
  }

  virtual void handleEvent (TEvent &e)
  {
    char buf[80];
    if (e.what == evBroadcast)
      if (e.message.command == cmMyNotification)
      {
        if (lb->range > 0)
        {
//          strcpy (buf, ((char *)(lb->list()->at (lb->focused))) );
          messageBox (mfInformation, "item:%d  '%s'", lb->focused, "Record");
          redraw();
        }
      }

    TDialog::handleEvent (e);
  }

};


class TTableListBox : public TListBox
{
  public:
  TTableListBox (TRect &r, ushort n, TScrollBar *s):  TListBox (r,n,s)
  {

  }

  virtual void getText (char *dest, short item, short maxLen)
  {
    RECORDNUMBER num;
    char name[65], temp[80];
    long count;
    DATE d;
    int month, day, year;
    int x;
    TTableDialog *parent;
    parent = (TTableDialog *)owner;

    if (1)
    {
      num = ((REC*)(list()->at(item)))->n;
      if (PXRecGoto (parent->handle, num) == PXSUCCESS)
      {
        pe (PXRecGet (parent->handle, parent->rec));
        pe (PXGetAlpha (parent->rec, 1, 60, name));
        pe (PXGetLong (parent->rec, 2, &count));
        pe (PXGetDate (parent->rec, 3, &d));
        pe (PXDateDecode (d, &month, &day, &year));
        sprintf (temp, "%s %5ld %02d/%02d/%04d\n", name, count, month, day, year);
        if (maxLen < 80)
          temp[maxLen-1] = 0;
        strcpy (dest, temp);
      }
      else
        *dest = EOS;
    }
    else
    *dest = EOS;

  }

  virtual void handleEvent (TEvent &e)
  {
        if( e.what == evKeyDown )
        {
          if (e.keyDown.keyCode == kbEnter)
            message (owner, evBroadcast, cmMyNotification, this);
//            message (owner, evCommand, cmCancel, this);
        }
        else
        if (e.what == evMouseDown)
        {
          if (e.mouse.doubleClick)
            message (owner, evBroadcast, cmMyNotification, this);
        }

        TListBox::handleEvent (e);
  }

};




//------------------------------------------------------------------------
//  display a dialog box containing a listbox
//------------------------------------------------------------------------
void TApp::ListDialog()
{
    TRecCollection *theCollection = new TRecCollection( 100, 10 );

    TDialog *pd = new TTableDialog( TRect( 0, 0, 76, 20 ), "TV Classes" );
    pd->options |= ofCentered;

    theCollection->hand = ((TTableDialog *)pd)->handle;

    // create a vertical scroll bar for the list box
    TScrollBar *listScroller = new TScrollBar( TRect( 71, 5, 72, 17 ) );

    // create a list box with 2 columns and associated scroller
    TTableListBox *listBox = new TTableListBox( TRect( 3, 5, 70, 17 ),
                                        1, listScroller );
    // associate the collection with the list box
    listBox->newList( (TCollection *) theCollection );

    // insert the list box with its scroller into the dialog box

    pd->insert( listBox );
    pd->insert( listScroller );

    ((TTableDialog *)pd)->Init (listBox);  // set and init

    // if the object was safely built, exec it as modal
    if( validView( pd ) )
        deskTop->execView( pd );

    // and a little clean up
    destroy( pd );
}

//========================================================================
int main(void)
{
    // now for the tought stuff
    TApp myApp;
    myApp.run();

    return 0;
}
