/*Ŀ
                                                                         
     Module:  PDXTBL.CPP                                                 
     Author:  Rick Kligman                                               
     Purpose: Code for Base Class table which handles Paradox Engine     
               Database stuff                                            
     Last Modified: 05-17-91 00:34am                                     
                                                                         
     Copyright 1991 Rick Kligman                                         
     This code may be freely used and distributed in commercial apps     
     provided some mention of PXBuddy++ is made in the documentation.    
                                                                         
     Version 1.00                                                        
   */

#include "pdxtbl.h"

//    ķ
//                     Constructor for pxtable class                 
//    ͼ

pxtable::pxtable()
{
  first_open      = 1;        // this will be first time table is opened
  tbl_open        = 0;        // table is not open
  blanks_as_zeros = TRUE;     // write blanks as zeros
}

//    ķ
//                     Destructor for pxtable class                  
//    ͼ

pxtable::~pxtable()
{
  if ( ! first_open )
      delete fldptr;
  if ( tbl_open )
      PXTblClose(th);
}

//    ķ
//                             Open a Table                          
//    ͼ

int pxtable::open(char *tablename, FIELDHANDLE fh)
{
  int   err;

  if ( *tablename != NULL) {
      strcpy(tblname, tablename);
      if (! first_open)
          delete fldptr;
      first_open = 1;
  }

  err = PXTblOpen(tblname, &th, fh, 0);
  CKERR;
  err = PXRecBufOpen(th, &rh);
  if ( ! err ) {
      err = PXRecBufEmpty(rh);
      if ( ! err )
          if ( first_open ) {
              err = PXRecNFlds(th, &numflds);
              if ( ! err ) {
                  fldptr = new absfld * [numflds + 1];
                  first_open = 0;
                  init_flds();
                  PXKeyNFlds(th, &keyed);     // determine if table is keyed
              }
          }
  }

  if ( err )
      PXTblClose(th);
  else
      tbl_open = 1;         // table is now open

  return err;       // will be PXSUCCESS if everything is OK
}

//    ķ
//                            Close a Table                          
//    ͼ

int pxtable::close()
{
  int   err;

  err = PXRecBufClose(rh);
  CKERR;

  err = PXTblClose(th);

  if ( ! err )
      tbl_open = 0;         // table is now closed

  return err;
}

//    ķ
//           Read the record and then ALL fields in a Table          
//    ͼ

int pxtable::read_rec()
{
  int     err;

  err = recget();
  CKERR;

  err = read_flds();

  return err;
}

//    ķ
//                       Read ALL fields in a Table                  
//    ͼ

int pxtable::read_flds()
{
  int     err;

  for (int i = 0; fldptr [i] != NULL; i++) {
      err = fldptr [i]->get();
      CKERR;
  }

  return (PXSUCCESS);
}

//    ķ
//            Write ALL fields in a Table and then the record        
//    ͼ

int pxtable::put_recupdate()
{
  int     err;

  err = put_flds();
  CKERR;

  err = recupdate();

  return err;
}

//    ķ
//            Write ALL fields in a Table and then the record        
//    ͼ

int pxtable::put_recappend()
{
  int     err;

  err = put_flds();
  CKERR;

  err = recappend();

  return err;
}

//    ķ
//            Write ALL fields in a Table and then the record        
//    ͼ

int pxtable::put_recinsert()
{
  int     err;

  err = put_flds();
  CKERR;

  err = recinsert();

  return err;
}

//    ķ
//                      Write ALL fields in a Table                  
//    ͼ

int pxtable::put_flds()
{
  int     err;

  for (int i = 0; fldptr [i] != NULL; i++) {
      err = fldptr [i]->put();
      CKERR;
  }

  return (PXSUCCESS);
}

//    ķ
//                     Get Next Record in the Table                  
//    ͼ

int pxtable::recnext()
{
  int   err;

  err = PXRecNext(th);
  if ( err == PXERR_ENDOFTABLE ) {
      err = PXSUCCESS;
      tblmarker = TRUE;
  }
  else
      tblmarker = FALSE;

  return err;
}

//    ķ
//                     Get Prev Record in the Table                  
//    ͼ


int pxtable::recprev()
{
  int   err;

  err = PXRecPrev(th);
  if ( err == PXERR_STARTOFTABLE ) {
      err = PXSUCCESS;
      tblmarker = TRUE;
  }
  else
      tblmarker = FALSE;

  return err;
}

