/*Ŀ
                                                                         
     Module:  PDXFLD.H                                                   
     Author:  Rick Kligman                                               
     Purpose: Class definition for Paradox fields                        
                                                                         
     Last Modified: 05-17-91 00:34am                                     
                                                                         
     Copyright 1991 Rick Kligman                                         
     This code may be freely used and distributed in commercial apps     
     provided some mention of PXBuddy++ is made in the documentation.    
                                                                         
     Version 1.00                                                        
   */


/*
 *      future enhancements:
 *
 *          member function set should check
 *            validity of number being set into field. That way
 *            when you write field to record buffer, data is OK.
 */

#ifndef RKPDXFLD_H
#define RKPDXFLD_H

#ifndef   __STRING_H
  #include <string.h>
#endif

#ifndef   __STDLIB_H
  #include <stdlib.h>
#endif

#ifndef   PXENGINE_H
  extern "C" {
       #include <pxengine.h>
  }
#endif

#ifndef   RKNONVERR_H
  #include "error.h"
#endif

#define   CKERR   if (err) return (err)

extern    class pxtable;

//    ķ
//                         Abstract class for Fields                   
//    ͼ

class absfld {
protected:

  FIELDHANDLE   fh;

public:

  absfld();
  ~absfld();

  virtual int   isa()             { return (0); }
  FIELDHANDLE   fhret()           { return ( fh ); }
  virtual int   get()             { return (-1); }

  virtual int   put(int = FALSE)  { return (-1); }

  virtual int   setinfo(pxtable&, char *) { return (-1); }

  virtual int   search(char *, int = SEARCHFIRST)
                        { return (-1); }

  virtual int   search(short,  int = SEARCHFIRST)
                        { return (-1); }

  virtual int   search(double, int = SEARCHFIRST)
                        { return (-1); }

  virtual int   search(long,   int = SEARCHFIRST)
                        { return (-1); }

          int   search_fld(TABLEHANDLE, RECORDHANDLE, int, int);
};

//    ķ
//                         Field class for CHARS                         
//    ͼ

class CharFld : public absfld
{
  pxtable*  tblp;     // pointer to base table class
  char      *data;
  int       size;

public:

  CharFld ();
  ~CharFld();

  int   isa()                     { return (1); }
        operator char *()         { return data; }
  void  operator = (char *);
  int   get();
  int   put(int = FALSE);
  int   setinfo(pxtable&, char *);
  int   search(char *srchvar, int mode = SEARCHFIRST);
};

//    ķ
//                         Field class for SHORTS                        
//    ͼ

class ShortFld : public absfld
{
  pxtable*  tblp;     // pointer to base table class
  short   data;

public:

  ShortFld();
  ~ShortFld();

  int   isa()                     { return (2); }
        operator short()          { return data; }
        operator short *()        { return &data; }
        operator >(int comp)      { return data > comp; }
        operator <(int comp)      { return data < comp; }
  void  operator = (short newval) { data = newval; }
  int   get();
  int   put(int = FALSE);
  int   setinfo(pxtable&, char *);
  int   search(short srchvar, int mode = 1);
};

//    ķ
//                         Field class for DOUBLES                       
//    ͼ

class DblFld : public absfld
{
  pxtable*  tblp;     // pointer to base table class
  double  data;

public:

  DblFld();
  ~DblFld();

  int     isa()                      { return (3); }
          operator double()          { return data; }
          operator double *()        { return &data; }
          operator >(double comp)    { return data > comp; }
          operator <(double comp)    { return data < comp; }
  void    operator = (double newval) { data = newval; }
  int     get();
  int     put(int = FALSE);
  int     setinfo(pxtable&, char *);
  int     search(double srchvar, int mode = SEARCHFIRST);
};

//    ķ
//                         Field class for DATES                         
//    ͼ

class DateFld : public absfld
{
  pxtable*  tblp;     // pointer to base table class
  long      data;
  char      datastr [11];

public:

  DateFld();
  ~DateFld();

  int   isa()                     { return (4); }
        operator char *()         { return datastr; }
  int   operator = (char *);
  int   get();
  int   put(int = FALSE);
  int   setinfo(pxtable&, char *);
  // int   search(TABLEHANDLE, int, char *srchvar, int mode = SEARCHFIRST);
  int   toint(int &mo, int &da, int &yr)
            { return ( PXDateDecode(data, &mo, &da, &yr) ); }
  int   frint(int mo, int da, int yr)
            { return ( PXDateEncode(mo, da, yr, &data) ); }
};


#endif
