/*Ŀ
                                                                         
     Module:  PDXFLD.CPP                                                 
     Author:  Rick Kligman                                               
     Purpose: Source code for Field class                                
                                                                         
     Last Modified: 05-17-91 00:34am                                     
                                                                         
     Copyright 1991 Rick Kligman                                         
     This code may be freely used and distributed in commercial apps     
     provided some mention of PXBuddy++ is made in the documentation.    
                                                                         
     Version 1.00                                                        
   */

#include "pdxfld.h"

#ifndef   __STDIO_H
  #include <stdio.h>
#endif

#include "pdxtbl.h"

//    ķ
//                     Constructor for absfld class                  
//    ͼ

absfld::absfld()
{
}

//    ķ
//                     Destructor  for absfld class                  
//    ͼ

absfld::~absfld()
{
}

//    ķ
//                     Constructor for CharFld class                 
//    ͼ

CharFld::CharFld()
{
  size = 0;
}

//    ķ
//                     Destructor  for CharFld class                 
//    ͼ

CharFld::~CharFld()
{
  if (size)
      delete data;
}

//    ķ
//                     Initialize CHAR Field                       
//    ͼ

int CharFld::setinfo(pxtable& tblptr, char *fldname)
{
  int     err;
  char    fldtype [6];    // will hold len of field...A5, A23, A176 etc..

  tblp = &tblptr;

  err = PXFldHandle(tblp->th, fldname, &fh);
  CKERR;

  err = PXFldType(tblp->th, fh, 6, fldtype);
  CKERR;

  size = atoi(fldtype + 1) + 1;       // get len of field plus NULL char

  data = new char [size];             // allocate memory for var storage
  if ( ! data )
      return (PXERR_OUTOFMEM);

  return PXSUCCESS;
}

//    ķ
//                 Read CHAR Field from record buffer              
//    ͼ

int CharFld::get()
{
  int   blank;
  int   err;

  err = PXFldBlank(tblp->rh, fh, &blank);
  CKERR;

  if (blank)                                // char field was blank
      data [0] = NULL;
  else
      err = PXGetAlpha(tblp->rh, fh, size, data);

  return (err);       // if no error then PXSUCCESS will be returned
}


// ķ
//                  Overload = to put contents into class                   
// ͼ

void  CharFld::operator = (char *newval)
{
  strncpy(data, newval, size);
  data [size - 1] = NULL;         // terminate the string
}

//    ķ
//                  Write CHAR Field to record buffer              
//    ͼ

int CharFld::put(int)
{
  int   err;

  err = PXPutAlpha(tblp->rh, fh, data);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                        Search a CHAR Field                      
//    ͼ

int CharFld::search(char *srchvar, int mode)
{
  int   err;
  RECORDHANDLE  newrh;

  err = PXRecBufOpen(tblp->th, &newrh);
  CKERR;

  err = PXRecBufEmpty(newrh);
  CKERR;

  err = PXPutAlpha(newrh, fh, srchvar);
  if ( err ) {
      PXRecBufClose(newrh);
      return err;
  }

  err = search_fld(tblp->th, newrh, tblp->keyed, mode);

  PXRecBufClose(newrh);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                     Constructor for ShortFld class                
//    ͼ

ShortFld::ShortFld()
{
}

//    ķ
//                     Destructor for ShortFld class                 
//    ͼ

ShortFld::~ShortFld()
{
}


//    ķ
//                     Initialize SHORT Field                      
//    ͼ

int ShortFld::setinfo(pxtable &tblptr, char *fldname)
{
  int     err;

  tblp = &tblptr;

  err = PXFldHandle(tblp->th, fldname, &fh);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                 Read SHORT Field from record buffer             
//    ͼ

int ShortFld::get()
{
  int   blank;
  int   err;

  err = PXFldBlank(tblp->rh, fh, &blank);
  CKERR;

  if (blank)                          // short field was blank
      data = 0;
  else
      err = PXGetShort(tblp->rh, fh, &data);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                 Write SHORT Field to record buffer              
//    ͼ

int ShortFld::put(int blank)
{
  int   err;

  if ( data == 0 && blank )
      err = PXPutBlank(tblp->rh, fh);
  else
      err = PXPutShort(tblp->rh, fh, data);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                       Search a SHORT Field                      
//    ͼ

int ShortFld::search(short srchvar, int mode)
{
  int   err;
  RECORDHANDLE  newrh;

  err = PXRecBufOpen(tblp->th, &newrh);
  CKERR;

  err = PXPutShort(newrh, fh, srchvar);
  if ( err ) {
      PXRecBufClose(newrh);
      return err;
  }

  err = search_fld(tblp->th, newrh, tblp->keyed, mode);

  PXRecBufClose(newrh);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                     Constructor for DblFld class                  
//    ͼ

DblFld::DblFld()
{
}

//    ķ
//                     Destructor for DblFld class                   
//    ͼ

DblFld::~DblFld()
{
}

//    ķ
//                     Initialize DOUBLE Field                     
//    ͼ

int DblFld::setinfo(pxtable &tblptr, char *fldname)
{
  int     err;

  tblp = &tblptr;

  err = PXFldHandle(tblp->th, fldname, &fh);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                 Read DOUBLE Field from record buffer            
//    ͼ

int DblFld::get()
{
  int   blank;
  int   err;

  err = PXFldBlank(tblp->rh, fh, &blank);
  CKERR;

  if (blank)                          // double field was blank
      data = 0;
  else
      err = PXGetDoub(tblp->rh, fh, &data);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                 Write DOUBLE Field to record buffer             
//    ͼ

int DblFld::put(int blank)
{
  int   err;

  if ( data == 0 && blank )
      err = PXPutBlank(tblp->rh, fh);
  else
      err = PXPutDoub(tblp->rh, fh, data);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                       Search a DOUBLE Field                     
//    ͼ

int DblFld::search(double srchvar, int mode)
{
  int   err;
  RECORDHANDLE  newrh;

  err = PXRecBufOpen(tblp->th, &newrh);
  CKERR;

  err = PXPutDoub(newrh, fh, srchvar);
  if ( err ) {
      PXRecBufClose(newrh);
      return err;
  }

  err = search_fld(tblp->th, newrh, tblp->keyed, mode);

  PXRecBufClose(newrh);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                     Constructor for DateFld class                 
//    ͼ

DateFld::DateFld()
{
}

//    ķ
//                     Destructor for DateFld class                  
//    ͼ

DateFld::~DateFld()
{
}

//    ķ
//                     Initialize DATE Field                       
//    ͼ

int DateFld::setinfo(pxtable &tblptr, char *fldname)
{
  int     err;

  tblp = &tblptr;

  err = PXFldHandle(tblp->th, fldname, &fh);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                 Read DATE Field from record buffer              
//    ͼ

int DateFld::get()
{
  int   blank;
  int   err;
  int   mo, da, yr;

  err = PXFldBlank(tblp->rh, fh, &blank);
  CKERR;

  if (blank) {                        // date field was blank
      strcpy(datastr, "");
  }
  else {
      err = PXGetDate(tblp->rh, fh, &data);
      CKERR;
      PXDateDecode(data, &mo, &da, &yr);
      yr -= 1900;
      if ( yr < 0 )     // in case we get something we didn't expect!
          yr = 0;
      sprintf(datastr, "%.2i/%.2i/%.2i", mo, da, yr);
  }

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//                  Write DATE Field to record buffer              
//    ͼ

int DateFld::put(int)
{
  int   err;

  //  if the date is blank it can be one of two things. If the user never
  //  enters the field then it will be NULL. If the user does go through
  //  the field and leaves it blank, Vermont converts the date to 00/00/00

  if ( *datastr == NULL )
      err = PXPutBlank(tblp->rh, fh);
  else
      err = PXPutDate(tblp->rh, fh, data);

  return (err);       // if no error then PXSUCCESS will be returned
}

//    ķ
//              Search a DATE Field with CHAR String               
//    ͼ
#if 0
int DateFld::search(char *srchvar, int mode)
{
  int   err = -1;
  RECORDHANDLE  newrh;

  err = PXRecBufOpen(tblp->th, &newrh);
  CKERR;

  err = PXPutDate(newrh, fh, srchvar);
  if ( err ) {
      PXRecBufClose(newrh);
      return err;
  }

  err = search_fld(tblp->th, newrh, tblp->keyed, mode);

  PXRecBufClose(newrh);

  return (err);       // if no error then PXSUCCESS will be returned
}
#endif

//    ķ
//                       Convert String to DATE                  
//    ͼ

int DateFld::operator = (char *newval)
{
  int   mo, da, yr, err;
  char  temp [3];

  strncpy(datastr, newval, 11);
  datastr [10] = NULL;

  temp [0] = *newval;
  temp [1] = *(newval + 1);
  temp [2] = NULL;

  mo = atoi(temp);

  temp [0] = *(newval + 3);
  temp [1] = *(newval + 4);

  da = atoi(temp);

  temp [0] = *(newval + 6);
  temp [1] = *(newval + 7);

  yr = atoi(temp);

  err = PXDateEncode(mo, da, yr, &data);

  return ( err );
}

//    ķ
//                           Search a Field                      
//    ͼ

int absfld::search_fld(TABLEHANDLE th, RECORDHANDLE rh, int keyed, int mode)
{
  int   err;

  if ( ! keyed )          // non keyed searches need to go to top of table
      PXRecGoto(th, 1);

  //  extra if on CLOSESTRECORD is done because even if it finds something
  //  it will return RECNOTFOUND since it is an inexact match

  if ( fh == 1 && keyed )
      err = PXSrchKey(th, rh, fh, mode);
  else
      err = PXSrchFld(th, rh, fh, mode);

  if (mode == CLOSESTRECORD && err == PXERR_RECNOTFOUND)
      err = PXSUCCESS;

  return (err);       // if no error then PXSUCCESS will be returned
}

