//	Program name..	Zinc Interface Library
//	Filename......	PWINDOW.HPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1991.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <ui_win.hpp>

/* ----- Definition of the UIW_POP_UP_WINDOW class ----- */
class UIW_POP_UP_WINDOW : public UIW_BUTTON
{
public:
	UIW_POP_UP_WINDOW(int left, int top, int width, char *a_string,
		UIW_WINDOW *window, USHORT a_btFlags, USHORT a_woFlags,
		void (*userFunction)(void *object, UIW_WINDOW *window, int ccode) = 0);
	virtual ~UIW_POP_UP_WINDOW(void);

	virtual int Event(const UI_EVENT &event);
	UI_WINDOW_OBJECT *First(void)
		{ return((UI_WINDOW_OBJECT *)window->First()); }
	UI_WINDOW_OBJECT *Last(void)
		{ return((UI_WINDOW_OBJECT *)window->Last()); }

	UIW_POP_UP_WINDOW &operator + (void *object)
		{ window->Add((UI_WINDOW_OBJECT *)object); return(*this); }
	UIW_POP_UP_WINDOW &operator - (void *object)
		{ window->Subtract((UI_WINDOW_OBJECT *)object); return(*this); }

protected:
	UIW_WINDOW *window;
	UI_REGION windowRegion;
	USHORT windowAdvancedFlags;

	void UserFunction(UI_EVENT &event);

private:
	void (*windowUserFunction)(void *object, UIW_WINDOW *window, int ccode);
	static void PopUpWindowUserFunction(void *button, UI_EVENT &event);
};

