//	Program name..	Zinc Interface Library
//	Filename......	PWINDOW.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1991.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <ui_win.hpp>

void UIW_POP_UP_WINDOW::PopUpWindowUserFunction(
	void *button, 
	UI_EVENT &event)
{
	((UIW_POP_UP_WINDOW *)button)->UserFunction(event);
}

UIW_POP_UP_WINDOW::UIW_POP_UP_WINDOW(
	int left,
	int top,
	int width,
	char *a_string,
	UIW_WINDOW *a_window,
	USHORT a_btFlags,
	USHORT a_woFlags,
	void (*a_windowUserFunction)(void *object, UIW_WINDOW *window, int ccode)) :
	UIW_BUTTON(left, top, width, a_string, a_btFlags | BTF_NO_TOGGLE,
		a_woFlags, UIW_POP_UP_WINDOW::PopUpWindowUserFunction)
{
	windowID[0] = ID_MENU_ITEM;
	windowID[1] = ID_BUTTON;
	depth = 0;

	windowUserFunction = a_windowUserFunction;
	window = a_window;
	windowRegion.left = a_window->true.left;
	windowRegion.top = a_window->true.top;
	windowRegion.right = a_window->true.right - a_window->true.left;
	windowRegion.bottom = a_window->true.bottom - a_window->true.top;
	windowAdvancedFlags = window->woAdvancedFlags;
	window->woAdvancedFlags |= WOAF_MODAL | WOAF_NO_DESTROY | WOAF_TEMPORARY;
}

UIW_POP_UP_WINDOW::~UIW_POP_UP_WINDOW(
	void)
{
	if (window && !FlagSet(woAdvancedFlags, WOAF_NO_DESTROY))
		delete window;
}

#pragma argsused
void UIW_POP_UP_WINDOW::UserFunction(
	UI_EVENT &event)
{
	/* Convert the window coordinates */
	if ((display->isText && FlagSet(window->woStatus, WOS_GRAPHICS)) ||
		(!display->isText && !FlagSet(window->woStatus, WOS_GRAPHICS)))
		display->RegionConvert(windowRegion, &window->woStatus, WOS_GRAPHICS);
	if (display->isText)
		window->woStatus &= ~WOS_GRAPHICS;
	else
		window->woStatus |= WOS_GRAPHICS;

	window->InformationSet(-screenID, display, eventManager, windowManager, paletteMapTable, this);
	window->true.left = true.left + windowRegion.left;
	window->true.top = true.top + windowRegion.top;
	window->true.right = window->true.left + windowRegion.right;
	window->true.bottom = window->true.top + windowRegion.bottom;
	window->relative = window->true;

	/* Attach the window */
	*windowManager + window;
}

int UIW_POP_UP_WINDOW::Event(
	const UI_EVENT &event)
{
	int ccode = UI_WINDOW_OBJECT::LogicalEvent(event, ID_WINDOW);
	switch (ccode)
	{
	case S_CURRENT:
	case S_NON_CURRENT:
		if (windowUserFunction)
			(*windowUserFunction)(this, window, ccode);
		break;
	}
	ccode = UIW_BUTTON::Event(event);
	return (ccode);
}

