/* pushdir.c - compiled under MS Quick C 1.00 */
/* needs popdir.c (in separate file) */
/* by R. Abramson, CIS ID 74676,3345 */
/* completely, utterly and totally public domain */
/*
*******************************************************************
Non-TSR pushdir that won't crap out and doesn't need env space.
Set up to go 30 deep to use up the 2K that the data file will take
up on the disk no matter.  More than 30 pushes will scroll
stuff off the bottom of the stack, that's all.  The stack file is
put in the same directory that command.com is in, determined
by looking at COMSPEC.  Since there's always a COMSPEC, this should
always find the same, valid, path (right?), unless, of course,
the user or a batch file changes COMSPEC in mid-session (or mid-
batch).  If the stack file doesn't exist, it'll be created.

Companion file is popdir.c.  Popdir won't go crazy if there's
no data file, or if it's all 'popped out', it just won't do
anything except beep in that event.  However, if for some reason
the data file is changed from the format that pushdir writes, who
knows what popdir will do... - although I don't see how that could
happen unless the user happened (for some reason) to edit the data file.

BTW, stack structure is an array of NULL padded strings.

I've been using this uneventfully.  Got tired of the TSR version
'cause it used memory and seemed wierd.  Didn't want to use more
environment space either.  Also, wanted something that didn't
freak out when the stack file was missing or empty.

The only drawback I can see is that these C programs, especially
popdir (because of system() I think), generate embarrasingly large
.exe files.  It's no problem on an AT with a reasonably fast drive,
however.

NOTE - If you 'rmdir' a pushed directory and try to popdir to it,
you'll get an 'Invalid directory' error message.  The invalid
path WILL be popped off the stack, but the current working dir
WILL NOT be changed.
*******************************************************************
*/

#include <stdio.h>
#include <string.h>

#define PUSHFILENAME "pushdir.stk"  /* you can change this, of course...*/
#define MAXPUSH 30  /* the depth of the directory stack */
#define LINELEN 67  /* max path length + drive: + NULL */

main()
{
char pushfile_dir[LINELEN];
/* declare array w/ 1 extra line */
char stk[MAXPUSH+1][LINELEN];
FILE *pushfile;
int i;

/* initialize the array */
for (i=0; i<MAXPUSH+1; i++)
	memset(stk[i],0,LINELEN);

/* find the directory that command.com is in */
strcpy( pushfile_dir, getenv("COMSPEC") );
i = strlen(pushfile_dir);
while (  (pushfile_dir[i] != '\\') && ( i > 0 )  )
	{
	pushfile_dir[i] = 0;
	i--;
	}
pushfile = fopen(strcat(pushfile_dir, PUSHFILENAME),"r+b");
/* if file didn't exist, create it */
if (pushfile == NULL)
	{
	pushfile = fopen(pushfile_dir, "w+b");
	}
else
	{
	/* read file contents into array, AFTER 0th element */
	fread(stk[1], sizeof(stk)-LINELEN, 1, pushfile);
	}
/* fill in 0th element w/ current working d:\dir */
getcwd(stk[0],LINELEN);
/* zero out trailing junk in 0th element */
for (i = strlen(stk[0]); i < LINELEN; i++)
	{
	*(stk[0]+i) = 0;
	}
/* you COULD check and beep at this point if stuff is scrolling off
the bottom, but I can't imagine why 30 pushes ain't enough... */

fseek(pushfile, 0L , 0 );
/* write out the new stack */
fwrite(stk, MAXPUSH*LINELEN, 1, pushfile);
fclose(pushfile);
}
