/* popdir.c - compiled under MS Quick C 1.00 */
/* IMPORTANT: needs 8192 stack space - relink after compiling */
/* => link popdir /stack:8192 */
/* see general comments in pushdir.c */

#include <stdio.h>
#include <string.h>
#include <dos.h>   /* needed for system() */

#define PUSHFILENAME "pushdir.stk"  /* or whatever you want to call it... */
#define MAXPUSH 30 /* stack depth */
#define LINELEN 67 /* maximum length of d:\dir plus NULL */

main()
{
/* declare an array 1 'line' longer than the stack */
char stk[MAXPUSH+1][LINELEN];
FILE *pushfile;
char pushfile_dir[LINELEN];
int i;

/* find the dir where command.com is */
strcpy( pushfile_dir, getenv("COMSPEC") );
i = strlen(pushfile_dir);
while (  (pushfile_dir[i] != '\\') && ( i > 0 )  )
	{
	pushfile_dir[i] = 0;
	i--;
	}
/* now get the old stack... */
pushfile = fopen(strcat(pushfile_dir, PUSHFILENAME),"r+b");
/* if file not found, no harm done cause nothing to pop, so exit */
if (pushfile == NULL)
	{
	printf("\a");
	exit(1);
	}
else
	{
	/* read file contents into all but the last line of the array... */
	fread(stk, sizeof(stk)-LINELEN, 1, pushfile);
	}
/* 'cd' as indicated, provided the 'popped' entry was not null */
if (stk[0][0] != 0)
	{
	chdir(stk[0]);  /*  change to popped dir */
	stk[0][2] = 0;  /*  truncate, leaving us with d: only */
	/* the following, I think, is why the .exe file's so big! */
	system(stk[0]); /* select the DRIVE */
	/* is there a more efficient way reliably to set the current drive??? */
	/* system() seems to pull in a lot of code from the run-time lib */
	/* but _dos_setdrive() seems screwed up */
	}
memset(stk[MAXPUSH], 0, LINELEN); /* clear any junk from (new) bottom line */
fseek(pushfile, 0L, 0 );
/* write out the new stack - starting AFTER the 0th (popped) 'line' */
fwrite(stk[1], MAXPUSH*LINELEN, 1, pushfile);
fclose(pushfile);
}
