           /* Pointer conversion routines for Turbo C     */
           /* Written by Ray Lambert [76077,1653] in 1988 */
           /* Happy pointing!!!!  :^)                     */


void far *normalize(void far *fptr)
   /*
       'Normalizes' a far pointer by converting it to a 20 bit address and
       then converting it back to a far pointer. The result has the smallest
       offset possible (0000h-000fh)
   */
{
   asm les         di, fptr
   asm mov         ax, es
   asm mov         bx, 0010h
   asm xor         dx, dx
   asm mul         bx
   asm add         ax, di
   asm jnc         nocarry
   asm inc         dx
nocarry:
   asm mov         di, ax
   asm and         di, 000fh
   asm mov         cx, 0004h
shiftfour:
   asm clc
   asm rcr         dx, 1
   asm rcr         ax, 1
   asm loop        shiftfour
   asm mov         fptr, di
   asm mov         fptr+2, ax
   return(fptr);
}

/* ******** */

unsigned long int fptolu(void far *fp)
   /*
       Converts a far pointer to a 20 bit address
       and returns it as a long unsigned int.
   */
{
   unsigned long int ulint;

   asm les     si, fp
   asm mov     ax, es
   asm mov     bx, 0010h
   asm mul     bx
   asm add     ax, si
   asm jnc     nocarry
   asm inc     dx
nocarry:
   asm mov     ulint, ax
   asm mov     ulint+2, dx
   return(ulint);
}

/* ******** */

void far *lutofp(unsigned long int ulint)
   /*
       Converts a 20 bit address which is stored in an unsigned long int
       to a far pointer (segment:offset format). The resulting far pointer
       will be 'normalized'. (smallest offset possible)
   */
{
   void far *fp;

   asm mov     ax, ulint
   asm mov     dx, ulint+2
   asm mov     si, ax
   asm and     si, 000fh
   asm mov     cx, 0004h
shiftfour:
   asm clc
   asm rcr     dx, 1
   asm rcr     ax, 1
   asm loop    shiftfour
   asm mov     fp, si
   asm mov     fp+2, ax
   return(fp);
}

