/*
 *    **************************************************
 *    *                                                *
 *    *                                                *
 *    *         PSET - Printer setup utility           *
 *    *                                                *
 *    *                    for the                     *
 *    *                                                *
 *    *              IBM Graphics printer              *
 *    *                                                *
 *    *              Version 2.2 04-24-88              *
 *    *                                                *
 *    *              Judson D. McClendon               *
 *    *                 P.O. Box 9946                  *
 *    *              Birmingham, AL 35220              *
 *    *                 205-853-8440                   *
 *    *            Compuserve [74415,1003]             *
 *    *                                                *
 *    *                                                *
 *    *          Use:  PSET opt opt opt ...            *
 *    *                                                *
 *    *                                                *
 *    *       The options are in the table below.      *
 *    *      The program ignores unknown options.      *
 *    *        Change the option names or setup        *
 *    *          strings to suit your printer.         *
 *    *      Be sure to use lower case key names       *
 *    *        in the table and end each setup         *
 *    *          string entry with a hex FF.           *
 *    *                                                *
 *    *       Use the printer reset function for       *
 *    *         your C compiler in the Reset()         *
 *    *         function below.  Functions for         *
 *    *        both MSC & Turbo C are included.        *
 *    *                                                *
 *    *                                                *
 *    **************************************************
 */



/*
 *    **************************************************
 *    *                                                *
 *    *                   Includes                     *
 *    *                                                *
 *    **************************************************
 */

#include <bios.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>



/*
 *    **************************************************
 *    *                                                *
 *    *                   Constants                    *
 *    *                                                *
 *    **************************************************
 */

#define TRUE 1
#define FALSE 0
#define BOOLEAN int
#define MAXLINES 20
#define PARMSPERPAGE (MAXLINES * 2)
#define LEFTSIDE 0
#define RIGHTSIDE 40



/*
 *    **************************************************
 *    *                                                *
 *    *             Function Declarations              *
 *    *                                                *
 *    **************************************************
 */

void main(int argc, char *argv[]);
void ShowPage(int begin, int nbrparms);
void ClearWork(void);
void Execute(char *parm, char *str);
void Reset(char *parm);
void DisplayParm(char *parm);



/*
 *    **************************************************
 *    *                                                *
 *    *           Global Variable Definition           *
 *    *                                                *
 *    **************************************************
 */

char
   header1[] = "Setup 2.1 for IBM Graphics printer\n"
               " Usage: PSET opt opt opt ..."
               "   where opt is any of the following options:",
   header2[] = "    OPTION  FUNCTION                        OPTION  FUNCTION",
   line[80];



/*
 *    **************************************************
 *    *                                                *
 *    *                Parameter Table                 *
 *    *                                                *
 *    **************************************************
 */

static struct {
   char *key, *data, *desc;
   } table[] = {

                  /* Common Functions */

      {"lf",         "\x00a\x0ff",           "Line Feed"},
      {"ff",         "\x00c\x0ff",           "Form Feed"},
      {"cr",         "\x00d\x0ff",           "Carriage Return"},
      {"page",       "\x00d\x00c\x0ff",      "Page Eject"},
      {"bell",       "\x007\x0ff",           "Sound Alarm"},
      {"can",        "\x018\x0ff",           "Clear Buffer"},
      {"reset",      "\x0ff",                "Reset Printer"},
      {"","",""},

                  /* Character Spacing */

      {"10cpi",      "\x012\x0ff",           "10 Chars Per Inch"},
      {"12cpi",      "\x01b\x03a\x0ff",      "12 Chars Per Inch"}, 
      {"15cpi",      "\x01b\x01f9\x0ff",     "15 Chars Per Inch"}, 
      {"16cpi",      "\x00f\x0ff",           "16 Chars Per Inch"}, 
      {"17cpi",      "\x00f\x0ff",           "17.1 Chars Per Inch"}, 
      {"","",""},

                  /* Line Spacing */

      {"6lpi",       "\x01b3\x024\x0ff",     "6 Lines Per Inch"},
      {"8lpi",       "\x01b3\x01b\x0ff",     "8 Lines Per Inch"},
      {"skip",       "\x01bN\x002\x0ff",     "Skip Perf"}, 
      {"noskip",     "\x01bO\x0ff",          "Don't Skip Perf"},
      {"","",""},

                  /* Character Attributes */

      {"exp",        "\x01bW\x001\x0ff",     "Set Expanded Print"},
      {"noexp",      "\x01bW\x000\x0ff",     "Reset Expanded Print"},
      {"emph",       "\x01bE\x0ff",          "Set Emphasized Print"},
      {"noemph",     "\x01bF\x0ff",          "Reset Emphasized Print"},
      {"enh",        "\x01bG\x0ff",          "Set Enhanced Print"},
      {"noenh",      "\x01bH\x0ff",          "Reset Enhanced Print"},
      {"","",""},

                  /* Character Sets */

      {"set1",       "\x01b7\x0ff",          "Character Set 1"},
      {"set2",       "\x01b6\x0ff",          "Character Set 2"},

      {"\x0ff"}      /* Table End Marker: Do not remove! */
   };



/*
 *    **************************************************
 *    *                                                *
 *    *                     Main                       *
 *    *                                                *
 *    **************************************************
 */

void main(int argc, char *argv[])

{

   BOOLEAN
      goodparms = FALSE;
   int
      nbrparms = 0,
      parnum,
      i;
   char
      *parm;


   for (parnum = 1; parnum < argc; parnum++) {        /* Decode Options */

      parm = argv[parnum];
      strlwr(parm);

      if (! strcmp(parm, "reset")) {
         Reset(parm);
         goodparms = TRUE;
         }

      else {

         for (i = 0; table[i].key[0] != '\x0ff'; i++) {

            if (! strcmp(parm, table[i].key) ) {
               Execute(parm, table[i].data);
               goodparms = TRUE;
               break;
               }

            }  /* for */

         }  /* else */

      }  /* for */


   if (! goodparms) {

      puts(header1);
      puts(header2);

      nbrparms = 0;
      for (i = 0; table[i].key[0] != '\x0ff'; i++) {  /* Count Parameters */
         nbrparms++;
         }

      for (i = 0; i < nbrparms; i += PARMSPERPAGE) {
         if (i) {
            fputs("Press a key to continue...", stdout);
            getch();
            putch('\r');
            fputs("                           ", stdout);
            putch('\r');
            }

         ShowPage(i, nbrparms);

         }  /* for */

      }  /* if */

}



/*
 *    **************************************************
 *    *                                                *
 *    *                  Show Page                     *
 *    *                                                *
 *    **************************************************
 */

void ShowPage(int begin, int nbrparms)

{

   int
      lx, lend,
      rx, rend,
      shift, size;


   lx = begin;

   if ((rend = begin + PARMSPERPAGE) > nbrparms)
      rend = nbrparms;

   rx = (lx + rend + 1) / 2;
   lend = rx;

   if (! *table[lx].key)
      lx++;

   if (! *table[rx].key)
      rx++;

   while (lx < lend) {

      ClearWork();

      if (lx < lend) {                        /* Left side */
         size = strlen(table[lx].key);
         if (size > 10)
            size = 10;
         shift = 10 - size;
         strncpy(&line[LEFTSIDE + shift], table[lx].key, size);
         if (size)
            line[LEFTSIDE + size + shift] = ':';
         size = strlen(table[lx].desc);
         if (size > 25)
            size = 25;
         strncpy(&line[LEFTSIDE + 12], table[lx].desc, size);
         lx++;
         }

      if (rx < rend) {                        /* Right side */
         size = strlen(table[rx].key);
         if (size > 10)
            size = 10;
         shift = 10 - size;
         strncpy(&line[RIGHTSIDE + shift], table[rx].key, size);
         if (size)
            line[RIGHTSIDE + size + shift] = ':';
         size = strlen(table[rx].desc);
         if (size > 25)
            size = 25;
         strncpy(&line[RIGHTSIDE + 12], table[rx].desc, size);
         rx++;
         }

      puts(line);                             /* Print line */

      }  /* while */

}



/*
 *    **************************************************
 *    *                                                *
 *    *                  Clear Work                    *
 *    *                                                *
 *    **************************************************
 */

void ClearWork(void)

{

   int i = 0;


   while (i < 79)
      line[i++] = ' ';

   line[79] = '\0';

}



/*
 *    **************************************************
 *    *                                                *
 *    *                    Execute                     *
 *    *                                                *
 *    **************************************************
 */

void Execute(char *parm, char *str)

{

   while(*str != '\x0ff') {
      fputc(*str, stdprn);
      str++;
      }

   DisplayParm(parm);

}



/*
 *    **************************************************
 *    *                                                *
 *    *                 Reset Printer                  *
 *    *                                                *
 *    **************************************************
 */

void Reset(char *parm)

{

   _bios_printer(_PRINTER_INIT, 0, NULL);    /* Reset LPT1: (Microsoft) */

/*
 *   Reset LPT1: for Turbo C
 *
 * biosprint(1, 0, 0);
 *
 */

   DisplayParm(parm);

}



/*
 *    **************************************************
 *    *                                                *
 *    *              Display Parameter                 *
 *    *                                                *
 *    **************************************************
 */

void DisplayParm(char *parm)

{

   fputs(parm, stdout);
   fputc(' ', stdout);

}
