/***********************************************************************
   Prtsel3. Version 3.1

   This program allows a LAN user to choose a network printer queue with
   options. Names of queues are displayed from an outside data base created
   by bDase or Clipper.

   Options are changed with this program.

   Original date: Jan. 25, 1994
   Last revised:  Mar. 17, 1994   2:00 pm
   Author:  Daniel D. Stuhlman
   Compiled with Borland C++  version 2.0

  Required files:

   capture.exe  Must be in the search path (Netware command)
   printer.dbf  Must be in same directory as program (user created data base)
                Contains names of LAN users and the names of the queues they
                have rights to use.

   queues.dbf   Must be in same directory as program (user created data base)
                Contains names of queues, their location and a brief
                description.

   This program is written as an engine.  The people maintaining the data
   base do not have to know anything about programming or how this program
   works.  The programmer does not have to know about who has rights to
   what queue or even the names of those who use the network.


   This program is coprighted by Illinois Student Assistance Commission.
   It is for demonstration purposes only.  There is no help available if
   it does not work.  It may not work on your system without modification.
   It is not warrented in any way.  The program may not be sold in any
   format. This program is shareware with all rights reserved, however,
   there is no registration fee.


***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
//#include "c:\borlandc\include\conio.h"
#include <conio.h>
#include <DOS.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <keyb.h>


//#define k_sp  32
//#define k_tab 9
//#define k_x   120
//#define k_X   88
// record length
#define rec_len 40

struct time t;
struct date today;
int top,r,b,l;
int i,prn1, prn2, page;
int stat,k;
int que_population; // Number of printers in queue
char c;
char *user;
char tm_file[80];  // Temporary file names used for opening files.//
char queues[70][28]; // Queue names
char display_line[60] [30]; //Selected queues for display
char queue_mess [70] [40]; //Messages for selected queues
char spaces[12];
long rec_offset;
char scrbuff[4096]; // Screen buffer
char scrbuff1[4096];  // Screen buffer
char ca_file[22];
int  done;
int  deflt;
char defaults[80]; // String with default values
char temp[120];
int  enab, ban, formf, formnum, limit, notif;
char copies[3], timeout[3], userI[13], drive;

void beep2(void);
void calltime(void);
void clrWin(int l, int top,int r, int b); //clear a window
void frame(int l, int top,int r, int b); // Make a frame with coordinates
void mess_vid(void);
void norm_vid(void);
void pDate(void);
void pTime(void);
void rev_vid(void);
void screen1(void);
void title(void);
void get_headers(void);
void open_files(void);
void get_option(void);
void options(void);
void read_dfiles(void);
void seek_address(void);
void screen2(void);
void choice1(void);
void help1(void);
void set_queue(void);
void file_error(void);
void read_file2(void);
void init(void);
void screen_d(void);
void timout_scr(void);
void help_d(void);
void banner_scr(void);
void formf_scr(void);
void copies_scr(void);
void form_scr(void);
void notif_scr(void);
void time_on_scr(void);
void file_scr(void);
void get_ques(void);


main (int, char *argv[])
 {
   textbackground(1);
   textcolor(14);
   init();
   strcpy(user, "        ");
   user = getenv("USER");
   strcpy(userI, user);

   printf("[2J");
   title();
   get_ques();  //Read the files

   screen1(); // Display the background
   screen2(); // display the queues
   gotoxy(1,4);
   do
    {
     choice1();
     get_option();
     options();
    }
   while (done == 0);
   _setcursortype(_NORMALCURSOR);
   gotoxy(1,24);  // Send cursor to bottom of screen
  }

void get_ques()
// Open and read the files
  {
   open_files();
   get_headers();
   read_dfiles(); // read first file
   read_file2();  // read and compare to second file
   close(prn1);
   close(prn2);
  }

void init()
{
 enab = 1;
 ban  = 0;
 notif= 0;
 strcpy(copies,"01");
 strcpy(timeout,"010");
 done = 0;
 formf = 1;
 deflt = 0; // 0 means use default options; 1 defaults were changed
 strcpy(spaces,"         ");
 strcpy(defaults," nb Nonotify ti=10 nff");

{
union REGS regs;
struct SREGS sregs;

   regs.h.ah = 0x19;
   intdosx(&regs,&regs, &sregs);
   drive = regs.h.al+65;

}

}

void get_option()
{
  int valid;
  valid = 0;
  do
  {
  gotoxy(26,18);
  textcolor(15+128);
  textbackground(4);
  cprintf("_");
  gotoxy(26,18);
  time_on_scr();
  c = getch();
  if ((c == k_CR) || (c == 27) || (c > 47 && c < 53) || (c > 64 && c < 74) ||
    (c > 96 && c < 106) || (c==0))
    valid = 1;
  else
  {
    beep2();
    gotoxy(30,18);
    mess_vid();
    cprintf("Invalid choice.  Please try again.");
    delay(1200);
    norm_vid();
    gotoxy(30,18);
    cprintf("                                  ");
  }
  if (c== '0')
   {
    beep2();
    valid = 0;
   }
  if  ((valid == 1) && (limit < 9)  && (c > k_4))
   {
   if ( ((c > 41 + limit) && (c < 52)) || ((c > 97 + limit) && (c < 106)))
   {
    beep2();
    gotoxy(30,18);
    mess_vid();
    cprintf("Invalid choice.  Please try again.");
    delay(1200);
    norm_vid();
    gotoxy(30,18);
    cprintf("                                  ");
    valid = 0;
   }
   }

  } while (valid == 0);

  gotoxy(26,18);
  if (c > 48)
  cprintf("%c",c);
}

void time_on_scr()
 {
  while (!kbhit())
   {
    textbackground(7);
    textcolor(1);
    calltime();
    norm_vid();
    _setcursortype(_NOCURSOR);
    }
  }

void options()
{
  if (c == 0)
   // 0 means a function or special key was hit
   {
    int spec;
    char b[4];
    spec = getch();
    switch (spec)

    {
      case 59 : {
                 help1();// F1 for help
                 break;
                }
      case 60 : // F2 change defaults
                {
                  int a;
                  deflt = 1;
                  screen_d();
                  do
                   {
                    timout_scr();
                    textbackground(7);
                    textcolor(1);
                    pTime();
                    norm_vid();
                    gotoxy(10,21);
                    _setcursortype(_NORMALCURSOR);
                    a = getch();
                    if (a == k_CR)
                     break;       // If <CR> leave do loop
                    if (a != k_tab)
                     {
                      gotoxy(10,21); // Enable timeout

                      if ((a == k_sp) || (a == k_x) || (a == k_X))
                       {
                       cprintf("%c",a);
                       }
                      if (a == k_sp)
                       {
                        enab = 0;
                        gotoxy(11,22);
                        cprintf("010");
                        strcpy(timeout,"010");
                       }
                     }

                      banner_scr(); // Banner help screen
                      gotoxy(23,21); // banner vs no banner
                      a = getch();
                      if (a == k_CR)
                       break;

                      if (a != k_tab)
		      {
                       if ((a == k_sp) || (a == k_x) || (a == 88))
                         cprintf("%c",a);
                       if ((a == k_x) || (a == 88))
                        {
                          ban = 1; // print banner
                          gotoxy(23,22);
                          cprintf(" ");
                        }
                       }
                      if (a == k_sp)
                       {
                        ban = 0;
                        gotoxy(23,22);
                        cprintf("x");
                       }

                      formf_scr();  // Formfeed help
                      gotoxy(40,21); // Formfeed?

                      a = getch();
                      if (a == k_CR)
                       break;

                      if (a != k_tab)
		      {
                       if ((a == k_sp) || (a == k_x) || (a == k_X))
                         cprintf("%c",a);
                       if ((a == k_x) || (a == k_X))
                        {
                          formf = 1; // yes, formfeed
                          gotoxy(40,21);
                          cprintf("x");
                          gotoxy(40,22);
                          cprintf(" ");
                        }
                       }
                      if (a == k_sp)
                       {
                        formf = 0;
                        gotoxy(40,22);
                        cprintf("x");
                       }


                     rev_vid();

                     copies_scr();
                     gotoxy(62,21); // Change number of copies
                     textcolor(15);
                     strcpy(b,"  ");
                      a = getche();
                       if (a == k_CR)
                       break;

                      if ((a != k_tab) && (a > 47) && (a < 58))
		      {


                       b[0] = a;
                       gotoxy(63,21);
                       cprintf(" ");
                       do
                       {
                        gotoxy(63,21);
                        a = getche();
                        if ((a == k_CR) || (a == 9))
                         {
                          break;
                         }

                        if ((a > 47) && (a < 58))
                         {
                          b[1] = a;
                          strcpy(copies,b);  // number of copies
                          break;
                         }

                        if (a > 57)
                          beep2();

                        } while ( ((a> 47) && (a< 58)) || (a==13) || (a==9) );
                       strcpy(copies,b);  // number of copies
                      }
                       else
                        {
                         gotoxy(62,21);
                         cprintf("01");
                        }

                     rev_vid();
                     timout_scr();
                     gotoxy(11,22); // Change number for timeout
                     textcolor(15);
                      a = getche();
                      if (a == k_CR)
                       break;

                       if ((a != k_tab) && (a > 47) && (a < 58))
		      {

                       strcpy(b,"  ");
                       b[0] = a;
                       do
                       {
                        gotoxy(12,22);
                        a = getche();
                        if ((a == k_CR) || (a == k_tab))
                         {
                          strcpy(timeout,b);  // timeout seconds
			  break;
                         }


                        if ((a > 47) && (a < 58))
                         {
                          b[1] = a;
                         }

                        if (a > 57)
                          beep2();

                        gotoxy(13,22);
                        a = getche();
                        if ((a == k_CR) || (a == k_tab))
                         {
                          strcpy(timeout,b);  // timeout seconds
			  break;
                         }


                        if ((a > 47) && (a < 58))
                         {
                          b[2] = a;
                          break;
                         }

                        if (a > 57)
                          beep2();

                        strcpy(timeout,b);  // timeout seconds
                        } while ( ((a> 47) && (a< 58)) || (a==13) || (a==9) );
                       strcpy(timeout,b);  // timeout
                      }
                       else
                        {
                         gotoxy(11,22);
                         cprintf("010");
                        }

                      rev_vid();
                      gotoxy(6,18);


                      form_scr();
                      gotoxy(52,22); // Form #
                      textcolor(15);
                      a = getch();
                      if (a == k_CR)
                       break;

                      (a != k_tab);
		      {
                       if ( (a> 47) && (a< 58))
                         cprintf("%c",a);
                       if ((a < 47) || (a > 57))
                        {
                          formnum = 0;
                          gotoxy(53,22);
                          cprintf("0");
                        }
                       }
                      if (a == k_sp)
                       {
                        formnum=0;
                        gotoxy(53,22);
                        cprintf("0");
                       }

                      rev_vid();

                      notif_scr();   // Help for notify
                      gotoxy(68,22); // Notify
                      textcolor(15);
                      a = getch();
                      if (a == 13)
                       break;

                      (a != k_tab);
		      {
                       if ((a == 121) || (a == 89))
                        {
                          notif = 1; // notify
                          gotoxy(68,22);
                          cprintf("y");
                        }
                       }
                      if (a == k_sp)
                       {
                        notif = 0;
                        gotoxy(68,22);
                        cprintf("n");
                       }


                   } while (a != 13);

                  puttext(0,3,79,20,scrbuff);



                 }
      case 73 : {  // Page up
                 if (page > 0)
                 page--;
                 screen2();
                 break;
                }
      case 81 : {  // Page down
                 if (page < que_population/8)
                 page++;
                 screen2();
                 break;
                }
      case 71 : // Home
                {
                 page = 0;
                 screen2();
                 break;
                }

      case 79 : // End
                {
                  page = que_population/8;
                  screen2();
                  break;
                }
      default : break;

    }
   }

  if (c == '1')
  // save to data file
   {
    gettext(0,3,79,20,scrbuff);
    file_scr();

//    gettext(0,12,79,16,scrbuff);
    rev_vid();
    clrWin(8,13,73,16);
    frame(8,13,73,16);
//    gotoxy(9,13); cprintf("");
    gotoxy(10,14);
    cprintf("Enter the name of a file to capture your printing:");
    gotoxy(11,15);
    cprintf("%c:",drive);
    _setcursortype(_NORMALCURSOR);
    gotoxy(13,15); gets(ca_file);

    gotoxy(1,24);
    norm_vid();
    char j, jj, kk, ll;
    char dr[3];
    strcpy(dr,"  ");
    dr[1]=drive;
    strcat(dr,":");
    jj = strncmp(ca_file," ",1);
    kk = strncmp(ca_file,"*",1);
    ll = strncmp(ca_file,"?",1);
    j = strlen(ca_file);

    if ((jj != 0) && (kk != 0) && (ll !=0) && (j > 1))
     {
      strcpy(temp,"capture /cr=");
      strcat(temp,dr);
      strcat(temp,ca_file);
      stat = system(temp);
      delay(2000);
      done = 1;
     }
    else
      {
       beep2();
       gotoxy(13,16);
       mess_vid();
       cprintf("Invalid character.  Please try again.");
       delay(1500);
       norm_vid();
       gotoxy(30,18);
       cprintf("                                     ");
      }

    puttext(0,3,79,20,scrbuff);
//  puttext(0,12,79,16,scrbuff);
    goto end1;
    }

  if (c == '2')
  // Show status
   {
    gettext(0,0,79,24,scrbuff);
    clrscr();
    stat = system("capture.exe /sh");
    gotoxy(3,23); cprintf("Hit any key to continue.");
    c = getch();
    puttext(0,0,79,24,scrbuff);
    goto end1;
   }

  if (c == '3')
   {
    done = 1;
    goto end1;
   }

  if (c == 'A' || c == 'a')
   {
    gotoxy(1,23);
    stat = system("endcap");
    done = 1;
    goto end1;
   }

   if (c == '4')
    {
    gettext(0,0,79,24,scrbuff);
    clrscr();
    stat = system("pconsole");
    gotoxy(3,23); cprintf("Hit any key to continue.");
    c = getch();
    puttext(0,0,79,24,scrbuff);
    goto end1;
    }


  if (c == 'B' || c == 'b')
   {
    if (page > 0)
     i = (page*8);
    else
     i = 0;
    set_queue();
    goto end1;
   }

   if (c == 'C' || c == 'c')
   {
    if (page > 0)
     i = (page*8)+1;
    else
     i = 1;
    set_queue();
   }

   if (c == 'D' || c == 'd')
   {
    if (page > 0)
     i = (page*8)+2;
    else
     i = 2;
    set_queue();
   }

   if (c == 'E' || c == 'e')
   {
    if (page > 0)
     i = (page*8)+3;
    else
     i = 3;
    set_queue();
   }

   if (c == 'F' || c == 'f')
   {
    if (page > 0)
     i = (page*8)+4;
    else
     i = 4;
    set_queue();
   }

   if (c == 'G' || c == 'g')
   {
    if (page > 0)
     i = (page*8)+5;
    else
     i = 5;
    set_queue();
   }

   if (c == 'H' || c == 'h')
   {
    if (page > 0)
     i = (page*8)+6;
    else
     i = 6;
    set_queue();
   }

   if (c == 'I' || c == 'i')
   {
    if (page > 0)
     i = (page*8)+7;
    else
     i = 7;
    set_queue();
   }

  if (c == 13)
    done = 1;
  if (c == 27)
    done = 1;
  end1:;
  _setcursortype(_NORMALCURSOR);
}

void set_queue()  //Execute capture command
 {
  strcpy(temp,"capture.exe /q=");
  strcat(temp,display_line[i]);
  if (deflt == 0)
  {
   strcat(temp, defaults);
  }
    else
    {
      if (ban == 1)
        strcat(temp," banner ");
      else
        strcat(temp," nb");
      if (notif == 1)
        strcat(temp," notify ");
      if (copies !="01")
       {
        strcat(temp," copies=");
        strcat(temp,copies);
       }
      else
        strcat(temp," copies=01");
      if ((timeout != "010") || (timeout != "10"))
       {
        strcat(temp," ti=");
        strcat(temp,timeout);
       }
      else
        strcat(temp,"timeout=10");
      if (formf == 0 )
        strcat(temp," no form feed");

    } // end else
    gotoxy(3,23);
    stat = system(temp);  // capture with the prepared command line
    done = 1;
 }

void title()
{
  textbackground(7);
  textcolor(1);
  clrWin(1,1,80,3);
  frame(1,1,80,3);

  gotoxy(5,2); cprintf("Local Area Network Spooled Printers");
  gotoxy(1,45); cprintf(" (PRTSEL3.1)");
  gotoxy(63,3); cprintf("User: ");
  gotoxy(69,3); cprintf(userI);
  calltime();
  pDate();
  textbackground(1);
  textcolor(14);
}

// Standard DS video procedures :
void rev_vid()
// reverse video
 {
  textbackground(4);
  textcolor(15);
 }

void norm_vid()
// Normal screen
 {
  textbackground(1);
  textcolor(14);
 }

void mess_vid()
 {
  textcolor(1);
  textbackground(3);
 }

void clrWin(int l, int top,int r, int b)
// clear a window
  {
   window(l,top,r,b);
   clrscr();
   window(1,1,80,25);
  }

void frame(int l, int top,int r, int b)
// Make a frame when given the co-ordinates

{
  char str1[1];
  int i,j,k,kk;
  strcpy(str1," ");
  for (i=l; i < b; i++)

    strcpy(str1,"");
    j = l;
    gotoxy(l,top);
    cprintf(str1);
    strcpy(str1,"");
    k = b;
    kk = b;
    for (i = l+1; i< r; i++)
      {
      gotoxy(i,top);
      cprintf(str1);
      gotoxy(i,b);
      cprintf(str1);
       }
      strcpy(str1,"");
    for (i = top+1; i < b; i++)
     {
      gotoxy(l,i);
      cprintf(str1);
      gotoxy(r,i);
      cprintf(str1);
     }

     strcpy(str1,"");
     gotoxy(r,top);
     cprintf(str1);
     strcpy(str1,"");
     gotoxy(r,b);
     cprintf(str1);
     strcpy(str1,"");
     gotoxy(l,b);
     cprintf(str1);

    return;
    }

void beep2()
  {
    sound(440);
    delay(20);
    sound(550);
    delay(20);
    sound(660);
    delay(20);
    sound(770);
    delay(20);
    sound(880);
    delay(25);
    nosound();
  }

void pTime()
// Put time on the screen
  {
   char ampm[3];
   int i;

   gettime(&t);
   gotoxy(69,2);
   strcpy(ampm, "am");
   if (t.ti_hour == 12)
     strcpy(ampm," pm");
   if (t.ti_hour > 12)
    {
     t.ti_hour= t.ti_hour - 12;
     strcpy(ampm,"pm");
    }

   cprintf("%d",t.ti_hour);
   if (t.ti_min < 10)
     cprintf(":0%d",t.ti_min);
   else
   cprintf(":%d",t.ti_min);
   if (t.ti_sec < 10)
     cprintf(":0%d",t.ti_sec);
   else
   cprintf(":%d",t.ti_sec);
   if (t.ti_hour > 9)
     i = 1;
     else
     i = 0;

   gotoxy(76 + i,2);
   cprintf(ampm);
  }

void calltime()
 {
  _setcursortype(_NOCURSOR);
  pTime();
  delay(80);
  _setcursortype(_NORMALCURSOR);
 }


void pDate()
  {
   getdate(&today);
   gotoxy(58,2);
   cprintf("%d/%d/%d",today.da_mon, today.da_day,today.da_year);
  }

void choice1()
  {
   rev_vid();
   clrWin(25,18,27,18);
   gotoxy(2,18);
   cprintf("Enter your choice:");
   norm_vid();
  }

void help1(void)
  {
   gettext(1,3,80,25,scrbuff1);
   rev_vid();
   clrWin(1,3,80,23);
   frame(1,3,80,23) ;
   gotoxy(20,3);
   cprintf("Help Screen");
   gotoxy(3,4);
   cprintf("PRTSEL3 ver. 3.1 helps you control where you want to send your print job.");
   gotoxy(3,5);
   gotoxy(3,6);
   cprintf("All the printers that you are able to use are displayed.  Choose the letter" );
   gotoxy(3,7);
   cprintf("on the left side to choose a printer with the options at the bottom of the");
   gotoxy(3,8);
   cprintf("screen.");
   gotoxy(3,10);
   cprintf("If you want to capture to a file hit 1.  This means all output will");
   gotoxy(3,11);
   cprintf("be saved to a file. Drive %c: is assumed. To use this file end capturing",drive);
   gotoxy(3,12);
   cprintf("by choosing ""'A'"" for local printer. This is the same as the Netware Endcap ");
   gotoxy(3,13);
   cprintf("command.");
   gotoxy(3,14);
   cprintf("To view the capture status, hit 2.");
   gotoxy(3,15);
   cprintf("To end this program without changes hit 3, <Escape> or <Enter>");
   gotoxy(3,16);
   cprintf("F2 enables changing the defaults on the bottom of the screen.");
   gotoxy(3,17);
   cprintf("Help is displayed when changing the default options.");
   gotoxy(3,20);
   cprintf("Call the Help Desk or enter ""'Help Capture'"" at any DOS prompt to learn");
   gotoxy(3,21);
   cprintf("more about the options.");
   gotoxy(14,23);
   cprintf("Hit any key to continue");

   while (!kbhit())
    {
     textbackground(7);
     textcolor(1);
     calltime();
     norm_vid();
     _setcursortype(_NOCURSOR);
    }
   c = getch();
   puttext(1,3,80,25,scrbuff1);
   _setcursortype(_NORMALCURSOR);

  }

void screen1(void)
{
  frame(1,4,80,14);
  gotoxy(7,4); cprintf(" Printer ");
  gotoxy(24,4); cprintf(" Location ");
  gotoxy(51,4); cprintf(" Message ");
  gotoxy(4,5);
  cprintf("(A) Local Printer             Do not use this choice on a shared printer.");
  gotoxy(2,15);
  cprintf("<Escape> to quit without making any changes.");
  gotoxy(2,16);
  cprintf("F1 Help   F2 Change default settings  1. Data file. 2. Show status  3. Exit.");
  gotoxy(2,20);
  cprintf("Default settings:");
  gotoxy(2,21);
  cprintf("Enable |x|    Banner| |   Formfeed   | |  Number of copies |01|");
  gotoxy(2,22);
  cprintf("Timeout |010| No ban|x|   No Formfeed|x|  Form # | 0|      Notify|n|");
  textcolor(15);
  gotoxy(10,21);
  cprintf("x");
  gotoxy(40,22);
  cprintf("x");
  gotoxy(11,22);
  cprintf("010");
  gotoxy(23,22);
  cprintf("x");
  gotoxy(62,21);
  cprintf("01");
  gotoxy(52,22);
  cprintf(" 0");
  gotoxy(68,22);
  cprintf("N");
}

void screen2 ()
// Display the queue information on the screen
{
 int j,jj;
 norm_vid();
 clrWin(4,6,78,13);

 if (que_population > 8)
  {
   limit = 8;
   norm_vid();
   gotoxy(2,17); cprintf("<Pg Up>, <Pg Dn>, <Home>, <End> to scroll printer choices");
  }
 else
  {
   limit = que_population;
   page = 0;
  }

 if (que_population > 7)
  {
   gotoxy(70,14);
   cprintf("screen %d",page+1);
  }
  int ll;

 for (k=0; k < limit; k++)
  {
    if (page*8+k <= que_population)
     {
      jj = k + (page*8); //Subscript of array
      gotoxy(4,6+k);
      ll = strlen(queue_mess[jj]);
      if (ll > 45)
        {
        strncpy(temp, queue_mess[jj],37);
        strcpy(queue_mess[jj], temp);
        }
      cprintf("(%c) %s  %s",k+66,display_line[jj],queue_mess[jj]);
      j = strncmp(display_line[k + (page*8)],"  ",2);
      if (j <= 0)
       {
        gotoxy(4,6+k);
        cprintf("    ");
       }
     }
   }
}


void screen_d()  // Screen box for changing defaults
 {
  gettext(0,3,79,20,scrbuff);
  rev_vid();
  clrWin(3,16,78,19);
  frame(3,16,78,19);
  gotoxy(6,17);
  cprintf("Change the default settings.  Use the <Tab> key to move from field to");
  gotoxy(6,18);
  cprintf("to field.  <Enter> to accept changes and end.                        ");
  norm_vid();
  textcolor(15);
 }

void help_d()
 {
  mess_vid();
  clrWin(3,5,78,12);
  frame(3,5,78,12);
 }


void timout_scr()
// Help for timeout
 {
   help_d();
   gotoxy(5,6);
   cprintf("Include this option if you want to print from an application without");
   gotoxy(5,7);
   cprintf("exiting.  The Timeout option sends data to the printer a specified number");
   gotoxy(5,8);
   cprintf("of seconds after the application last writes to the file. Increase the");
   gotoxy(5,9);
   cprintf("Timeout if only part of the file is printed.  If using a Postscript ");
   gotoxy(5,10);
   cprintf("printer, disable Timeout. That means TI=0 or make Enable a blank.");
   gotoxy(5,11);
   cprintf("For example: 015 means wait 15 seconds before sending data to printer.");
   norm_vid();
  }

void banner_scr()
// Help for banner
 {
   help_d();
   gotoxy(5,6);
   cprintf("If Banner is enabled the printer will print a banner page at the ");
   gotoxy(5,7);
   cprintf("beginning of your print job. Your logon name will be on the banner page.");
   gotoxy(5,8);
   cprintf("Enter an ""X"" to enable or <space> to disable.");
   norm_vid();
  }

void formf_scr()
// Help for form feed option
 {
   help_d();
   gotoxy(5,6);
   cprintf("Include this option to enable a form feed after your job has been");
   gotoxy(5,7);
   cprintf("printed. FormFeed enabled means that the printer starts printing the next");
   gotoxy(5,8);
   cprintf("job at the top of the next sheet of paper.  If an application sends a ");
   gotoxy(5,9);
   cprintf("form feed at the end of a print job, adding this option causes a blank ");
   gotoxy(5,10);
   cprintf("page to be fed through printer. WordPerfect and 1-2-3 are among the ");
   gotoxy(5,11);
   cprintf("programs that send a form feed when done printing.");
   norm_vid();
  }

void copies_scr()
// Help for number of copies
 {
   help_d();
   gotoxy(5,6);
   cprintf("Use this option to indicate how many copies you want to print.");
   gotoxy(5,7);
   cprintf("Default is 1. Enter two digits for number of copies. System allows ");
   gotoxy(5,8);
   cprintf("up to 99 copies.");
   norm_vid();
  }

void form_scr()
// Help for form number
 {
   help_d();
   gotoxy(5,6);
   cprintf("Use this option to indicate which form number to use.  At this time");
   gotoxy(5,7);
   cprintf("we have not defined forms other than 0.");
   norm_vid();
  }

void notif_scr()
// Help for Notify
 {
   help_d();
   gotoxy(5,6);
   cprintf("Use this option if you want the file server to send you a message");
   gotoxy(5,7);
   cprintf("when your print job is completed.");
   gotoxy(5,8);
   cprintf("Enter a ""Y"" to enable or ""N"" for no.");
   norm_vid();
  }

void file_scr()
// Help for saving to a file
 {
   help_d();
   gotoxy(5,6);
   cprintf("Use this option if you want to save all printer output to a disk file.");
   gotoxy(5,7);
   cprintf("The '%c:' for the drive name is part of the program. Enter a valid",drive);
   gotoxy(5,8);
   cprintf("file name. You may include full directory names. Ex. test1.scr.");
   gotoxy(5,9);
   cprintf("Note! File names may not start with or include blank spaces, *, or ?");
   gotoxy(5,10);
   cprintf("In order to use the file you must end the capturing either with the");
   gotoxy(5,11);
   cprintf("ENDCAP command at a DOS prompt or local printer option in this program.");
   norm_vid();
  }

/**********************************/

long s1_pointer, s2_pointer;  //pointers to file positions//


//This routine gets the header length and the record size from the
//two input files

 struct  // Structure of the db_file header//
  {
   char version;
   char update[3];
   unsigned long num_of_records;
   unsigned int  len_header;
   unsigned int  len_record;
  } db_file1, db_file2;

 struct // Structure of name-queue database
  {
   char user_name[12];
   char que_name[27];
  }pr_file;

 struct // Structure of queue-message database
  {
   char location[4];
   char message[36];
   char que_name[27];
  }pr_file2;

void seek_address()
 {
  char temp;
  temp = user[0];
  long jj;
  switch (temp)
   {
    case 'A'    : jj = 0; break;
    case 'B'    : jj = 0; break;
    case 'C'    : jj = ((db_file1.num_of_records/12) * rec_len);
                   break;
    case 'D'    : jj = ((db_file1.num_of_records/12) * rec_len *2); break;
    case 'E'    : jj = ((db_file1.num_of_records/12) * rec_len *2);
    case 'F'    : jj = ((db_file1.num_of_records/12) * rec_len *3);
    case 'G'    : jj = ((db_file1.num_of_records/12) * rec_len *3); break;
    case 'H'    : jj = ((db_file1.num_of_records/12) * rec_len *4);break;
    case 'I'    : jj = ((db_file1.num_of_records/12) * rec_len *4);break;
    case 'J'    : jj = ((db_file1.num_of_records/12) * rec_len *5);
    case 'K'    : jj = ((db_file1.num_of_records/12) * rec_len *5); break;
    case 'L'    : jj = ((db_file1.num_of_records/12) * rec_len *6); break;
    case 'M'    : jj = ((db_file1.num_of_records/11) * rec_len *6); break;
    case 'N'    : jj = ((db_file1.num_of_records/12) * rec_len *7); break;
    case 'O'    : jj = ((db_file1.num_of_records/11) * rec_len *7); break;
    case 'P'    : jj = ((db_file1.num_of_records/11) * rec_len *7); break;
    case 'Q'    : jj = ((db_file1.num_of_records/12) * rec_len * 8); break;
    case 'R'    : jj = ((db_file1.num_of_records/12) * rec_len * 8); break;
    case 'S'    : jj = ((db_file1.num_of_records/12) * rec_len *9); break;
    case 'T'    : jj = ((db_file1.num_of_records/12) * rec_len *9); break;
    case 'U'    : jj = ((db_file1.num_of_records/12) * rec_len *9); break;
    case 'V'    : jj = ((db_file1.num_of_records/12) * rec_len *10); break;
    case 'W'    : jj = ((db_file1.num_of_records/12) * rec_len *11); break;

    default      : jj = ((db_file1.num_of_records/11) * rec_len *8);
   }
  rec_offset = rec_offset + jj;
  lseek(prn1,rec_offset,0); //Start at beginning
 }

void read_dfiles()
// Read the first data file and populate the array

 {
   char name_i[13];
   char temp[13];

   int j, l;

   strcat(user,spaces);
   k = 0;
   pr_file.user_name[0] = 0;
   rec_offset = (db_file1.len_header+1);
   seek_address();  //If this is the first read move file pointer
   for (i=1; i <=(db_file1.num_of_records); i++)
     {
      read(prn1,&pr_file,40);
      j = strncmp(pr_file.user_name, user, 12);
      if (j==0)
       {
         strncpy(display_line[k],pr_file.que_name,19); //**
         k++;

       }
      if (j>0 && k>0)
       {
         i = 59999;
       }
      if (j>0 && k==0)
       {
        rec_offset = rec_offset - 40;
        lseek(prn1,rec_offset,0);
       }

    /*   if (j<0 && k==0)
       {
        rec_offset = rec_offset + 160;
        lseek(prn1,160,1);
       }
     */
     }
     que_population = k;
 }


void read_file2()
// Read the second data file and copy it to the first to
// create the message part of the screen
  {
    int j,jj,kk,ll, L;
    char temp1[19];
    char temp2[19];

    rec_offset = (db_file2.len_header+1);
    lseek(prn2,rec_offset,0);
    j = 0; kk = 0;
    strcpy(pr_file2.location, "");
    strcpy(pr_file2.que_name, "");
    strcpy(pr_file2.message, "");
    for (i = 0; i < que_population; i++)
      {
       strcpy(queue_mess[i],"");
      }

    for (i = 0; i < que_population; i++)
     {
       do
        {
          read(prn2,&pr_file2,68);
          ll = strlen(display_line[i])-1;
          strncpy(temp1,pr_file2.que_name,ll);
            jj = eof(prn2);
          strcpy(temp2, display_line[i]);
          kk = strnicmp(temp1, temp2,ll);
        } while ((kk <0) && (jj !=1));

       if ((kk == 0) && !(eof(prn2)) && (j > -1));
        {
          queue_mess[j][0] = 0;
          temp[0] = 0;  temp2[0] = 0;
          strncpy(queue_mess[j], pr_file2.location, 4);
          strcat(queue_mess[j],"  ");
          strncpy(temp,pr_file2.message,30);
          strcat(queue_mess[j], temp);
          j++;
        }
     }
   }


void get_headers()
 {
   i = sizeof(db_file1);
   read(prn1,&db_file1,sizeof(db_file1));
   read(prn2,&db_file2,sizeof(db_file2));
 }

void file_error()
// Error message when the data bases aren't found
  {
   beep2();
   mess_vid();
   clrWin(3,20,63,23);
   frame(3,20,63,23);
   gotoxy(6,21);
   cprintf("Required file  %s doesn't exist.\n", tm_file);
   gotoxy(6,22);
   cprintf("Please call the Help Desk.  Program is ending.");
   gotoxy(1,24);
   norm_vid();
   delay(2000);
   exit(1);
  }

void open_files()
 {
   strcpy(tm_file,"printer.dbf");

   //   strcpy(tm_file,"k:\\shared\\prntnew\\prntr.dbf");
   prn1 = open(tm_file,0x20); // read_only, share
   if (prn1 < 0)
    {
    strcpy(tm_file,"k:\\shared\\prntr\\prntr.dbf");
     prn1 = open(tm_file,0x20); // read_only, share
    }
   if (prn1 < 0)
     file_error();

   strcpy(tm_file,"queues.dbf");
   prn2 = open(tm_file,0x20);
   if (prn2 < 0)
    {
     strcpy(tm_file,"k:\\shared\\prntr\\queues.dbf");
     prn2 = open(tm_file,0x20);
    }
   if (prn2 < 0)
     file_error();

 }

// end


