
// +--------------------------------------------------------------------------+
// |                                                                          |
// |      Window Property Enumeration Utility by Mark Gamber 11/12/93         |
// |                                                                          |
// |               Public Domain - May be freely distributed.                 |
// |                                                                          |
// +--------------------------------------------------------------------------+


#include "windows.h"


BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );           //  Prototypes
int CALLBACK PropEnumProc( HWND, LPSTR, HANDLE );


HINSTANCE hInst;                                           //  Global variables
BOOL Capture;
HWND MainDlg;


                                                        //  Program Entry Point
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrev,
                    LPSTR lpCmd, int nShow )
{
   hInst = hInstance;             //  Save instance handle and call dialog proc
   DialogBox( hInst, MAKEINTRESOURCE( 10000 ), NULL, MainDlgProc );
   return( FALSE );
}


// +--------------------------------------------------------------------------+
// |                                                                          |
// |                        Main window (dialog box)                          |
// |                                                                          |
// +--------------------------------------------------------------------------+

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
      {
         SetWindowPos( hDlg, HWND_TOPMOST, 0, 0, 0, 0, //  Make ourself topmost
                       SWP_NOMOVE | SWP_NOSIZE );
         Capture = FALSE;
         MainDlg = hDlg;          //  Initialize capture flag and dialog handle
         return( TRUE );
      }


      case WM_COMMAND:
      {
         if( wParam == 103 || wParam == IDCANCEL )    //  If "Close" pressed...
         {
            if( Capture )
               ReleaseCapture();             //  If capture enabled, disable it

            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         if( wParam == 102 )                     //  If "New" button pressed...
         {
            SetCapture( hDlg );                  //  Set mouse capture and exit
            Capture = TRUE;
         }
         break;
      }


      case WM_MOUSEMOVE:                         //  When the mouse is moved...
      {
         POINT Pt;
         HWND hNew;
         char str[ 128 ];

         if( ! Capture )                       //  If capture is disabled, exit
            break;

         Pt.x = LOWORD( lParam );             //  Convert window coordinates to
         Pt.y = HIWORD( lParam );                        //  screen coordinates
         ClientToScreen( hDlg, (LPPOINT)&Pt );
         hNew = WindowFromPoint( Pt );        //  Look for window under pointer
         if( ! hNew )
            break;                                            //  If none, exit

         if( ! GetWindowText( hNew, str, 128 ) )   //  If no caption, get class
            GetClassName( hNew, str, 128 );

         SetDlgItemText( hDlg, 100, str );            //  Display in dialog box
         break;
      }


      case WM_LBUTTONDOWN:                        //  Left mouse button pressed
      {
         HWND hNew;
         POINT Pt;

         if( Capture )                             //  If capture is enabled...
         {
            Capture = FALSE;                       //  Disable and mark as such
            ReleaseCapture();
         }
         else
            break;                                //  Otherwise, get outta here

         Pt.x = LOWORD( lParam );             //  Convert window coordinates to
         Pt.y = HIWORD( lParam );                        //  screen coordinates
         ClientToScreen( hDlg, (LPPOINT)&Pt );
         hNew = WindowFromPoint( Pt );        //  Look for window under pointer
         if( ! hNew )
            break;                                 //  If no window there, exit
                                            //  Empty the listbox and enumerate
         SendMessage( GetDlgItem( hDlg, 101 ), LB_RESETCONTENT, 0, 0 );
         EnumProps( hNew, (PROPENUMPROC)PropEnumProc );
         break;
      }
   }
   return( FALSE );
}


// +--------------------------------------------------------------------------+
// |                                                                          |
// |         PropEnumProc(): Property Enumeration Callback Function           |
// |                                                                          |
// +--------------------------------------------------------------------------+

int CALLBACK PropEnumProc( HWND hWnd, LPSTR lpStr, HANDLE hData )
{
   char str[ 256 ];

   if( HIWORD( (DWORD)lpStr ) == 0 )               //  If it's an integer ID...
      wsprintf( str, "%u", (WORD)lpStr );       //  Print the integer to string
   else
      lstrcpy( str, lpStr );                       //  Else, copy string passed

   if( lstrlen( str ) )                             //  Put string into listbox
      SendMessage( GetDlgItem( MainDlg, 101 ), LB_ADDSTRING, 0,
                   (LPARAM)(LPSTR)str );
   return( TRUE );
}

