#ifndef __TRANSFER_ARRAYS
#define __TRANSFER_ARRAYS

#include <owl\owlpch.h>
#pragma hdrstop

#include <cstring.h>
#include <classlib\arrays.h>
#include <classlib\assoc.h>
#include <owl\listbox.h>
#include <owl\combobox.h>

class TfElement
{
	UINT            resID;
	string          sText;
	WORD            wState;
	void            *pvTransfer;

	void    GetFromControl (TControl *ctrl);
	void    StoreToControl (TControl *ctrl);

public:
	TfElement (UINT id);

	// custom transfer buffer definition
	void    SetTransferBuffer (void *transferBuffer) { pvTransfer = transferBuffer; }

	// functions for setting values of controls
	LPCSTR  GetText ()                  { return sText.c_str (); }
	void    SetText (LPCSTR lpszText)   { sText = (lpszText ? lpszText : ""); }

	// functions for getting values of controls
	WORD    GetCheck ()                 { return wState; }
	void    SetCheck (WORD w)           { wState = w; }

	BOOL    operator== (const TfElement& elem) { return (resID == elem.resID); }

	// functions used to transfer to or from the control
	static void TransferFromDlg (TWindow* win, void* param);
	static void TransferToDlg (TWindow* win, void* param);
};

typedef TIArrayAsVector<TfElement>          TfElementArray;

class TTransferArray
{
	TfElementArray      arrayElems;

	TfElement           *GetElement (UINT resID);

public:
	TTransferArray ();

	void        TransferData (TWindow *win, TTransferDirection direction);

	TfElement&  operator[] (UINT resID)         { return *GetElement (resID); }

	UINT        GetRadioChecked (UINT resIDfrom, UINT resIDto);
};

class TITransferArray
{
	TTransferArray	*array;

public:
	TITransferArray ()											{ array = NULL; }

	void			SetTransferArray (TTransferArray *_array) 	{ array = _array; }
	TTransferArray *GetTransferArray ()							{ return array; }
};

#define DECLARE_USETRANSFERARRAY(cls,cls1)              \
  private:                                              \
	TITransferArray	userTransfer;						\
  public:                                               \
	TTransferArray	transfer;							\
	void SetTransferArray (TTransferArray *array)		\
		{                                               \
			userTransfer.SetTransferArray (array);      \
		}                                               \
	void TransferData (TTransferDirection direction)    \
		{                                               \
			if (userTransfer.GetTransferArray ())		\
			{                                           \
				userTransfer.GetTransferArray ()->		\
						TransferData (this, direction);\
			}                                           \
			else                                        \
			{                                           \
				transfer.TransferData (this, direction);\
			}                                           \
		}

class TTransferDialog : public TDialog
{

public:
	TTransferDialog (TWindow *wnd, TResId resID, TModule *module = NULL)
		: TDialog (wnd, resID, module) { }

	DECLARE_USETRANSFERARRAY(TTransferDialog, TDialog);
};

#endif
