#ifndef __PROPERTY_DIALOGS
#define __PROPERTY_DIALOGS

#include <owl\owlpch.h>
#pragma hdrstop

#include <classlib\arrays.h>

#ifndef USETRANSFERARRAYS
  #define USETRANSFERARRAYS	FALSE
#endif

#define DEFTABWIDTH			64
#define DEFWIDEMARGIN		6

#if USETRANSFERARRAYS
  #include "tfarry.h"
#endif

class TPropertyTab;
class TPropertyPage;
class TPropertyDialog;

typedef void (*TPageActionFunc)(TPropertyPage* page, void* param);
typedef BOOL (*TPageCondFunc)(TPropertyPage* page, void* param);

typedef void (TPropertyDialog::*TPageActionMemFunc)(TPropertyPage* page, void* param);
typedef BOOL (TPropertyDialog::*TPageCondMemFunc)(TPropertyPage* page, void* param);

void	UseSmallFont (HWND HWindow);

class Tab
{
public:
	enum Style {
			SingleHeight 	= 0x00,
			VariableWidth 	= 0x00,
			DoubleHeight	= 0x01,
			FixedWidth 		= 0x02,
			ColorActive		= 0x04,
			Collapsing		= 0x08,
			Justified		= 0x10,
			Stacked			= 0x20,
			AllowDupPages	= 0x40,
			CreateOnDemand	= 0x80,
			WideMargins		= 0x100,
			AutoTabResize	= 0x200,
			};
};

class TPropertyPage : public TDialog
{
	friend	TPropertyDialog;	// allows access to pdlgParent

	int 			nThisTab;

protected:
	TPropertyDialog	*pdlgParent;

	void    		CmOk ();      	// IDOK
	void    		CmCancel ();    // IDCANCEL
	void 			EvSysCommand (UINT cmdType, TPoint& pt);

	BOOL 			CheckHotKey (TDialog *dlg = NULL);

public:
	TPropertyPage (TResId resID, TModule *module = 0);
	~TPropertyPage ();

	TPropertyDialog& GetPropertyDialog ()	{ return *pdlgParent; }
	TWindow			*GetParentWindow ();
	int				ThisTab ()				{ return nThisTab; }

	void 			SelectTab (int nTab = -1);
	void			SelectNext ();
	void			SelectPrevious ();

	virtual void	AfterSelected ()		{ /* you can override this -- */ }

	void			EnableTab (int nTab = -1, BOOL bEnable = TRUE);
	BOOL			IsTabEnabled (int nTab = -1);

	virtual BOOL	SaveData ();

	int             MessageBox (const char far* text,
								const char far* caption = 0,
								UINT            type = MB_OK);

#if USETRANSFERARRAYS
	DECLARE_USETRANSFERARRAY(TPropertyPage, TDialog);
#endif

	DECLARE_RESPONSE_TABLE (TPropertyPage);
};

class TPropertyDialog : public TDialog
{

protected:
	TPropertyTab	*pTabs;

	int				DoExecute ();

	void			EvDestroy ();
	BOOL    		EvInitDialog(HWND hWndFocus);
	void 			SizeTabWnd (TRect& client);
	void 			EvSysCommand (UINT cmdType, TPoint& pt);

	virtual void	AdjustMargin (TRect& rc);

public:
	TPropertyDialog (TWindow *pParent, TResId resID, Tab::Style style = Tab::SingleHeight | Tab::VariableWidth, TModule *module = 0);
	~TPropertyDialog ();

	static void		SetHookInstance (HINSTANCE hInstance);
	static void 	TabColorChange (TApplication *application = NULL);

	void			SetupWindow ();
	void 			Destroy (int retValue = 0);
	void			EvSize (UINT, TSize& size);

	// get reference to a particular page
	TPropertyPage&	GetPageRef (int nTab = -1);
	int				GetEntryCount ();

	// function to add a new tab
	virtual void	Add (LPCSTR lpszTab, TPropertyPage *pPage, BOOL bEnabled = TRUE);

	virtual void	CmOk ();      	// IDOK
	virtual void	CmCancel ();    // IDCANCEL
	virtual void	CloseAction (int retValue);

	void 			SelectTab (int nTab);
	virtual void	AfterSelected (int nTab)	{ /* you can override this -- */ }

	// global properties for every tab
	void 			SetActiveColor (TColor color = TColor::Black);
	void 			SetFixedTabWidth (int nWidth = DEFTABWIDTH);
	void 			SetWideMarginWidth (int nWidth = DEFWIDEMARGIN);

	// page iterators that take function pointers
	TPropertyPage*	FirstPageThat (TPageCondFunc test, void* paramList = 0);
	void            ForEachPage (TPageActionFunc action, void* paramList = 0);

	// page-iterators that take pointers to member functions
	TPropertyPage*	FirstPageThat (TPageCondMemFunc test, void* paramList = 0);
	void            ForEachPage (TPageActionMemFunc action, void* paramList = 0);

	// similar to ForEach - sends Windows message to each page
	LRESULT 		SendMsgToEachPage (UINT msg, WPARAM wParam = 0, LPARAM lParam = 0);

	DECLARE_RESPONSE_TABLE(TPropertyDialog);
};

#endif
