#ifndef __FONT_PROPDLG
#define __FONT_PROPDLG

#include <owl\combobox.h>
#include <owl\static.h>
#include <owl\choosefo.h>
#include <owl\printer.h>
#include <owl\listbox.h>
#include "propdlg.h"

// ---------------------------------------------------
// private definitions
// ---------------------------------------------------
class TFontSpec
{
	int		nType;
	int		nFamily;
	LOGFONT	lf;

public:
	TFontSpec (int nType, const LOGFONT& lf, int nFamily);

	LPCSTR		GetName ()		{ return lf.lfFaceName; }
	int			GetType ()		{ return nType; }
	int			GetFamily ()	{ return nFamily; }
	LOGFONT&	GetLogFont ()	{ return lf; }

	BOOL	operator< (TFontSpec);
	BOOL	operator== (TFontSpec);
};

typedef TISArrayAsVector<TFontSpec>	TFontList;

class TSampleStatic : public TStatic
{
	TColor		colorText;

public:
	TSampleStatic (TWindow *, int resourceID, TModule *module = 0);

	void		SetupWindow ();
	void		Paint (TDC&, BOOL, TRect&);

	void		SetTextColor (TColor color);
};

class TODComboBox : public TComboBox
{
	void  		DrawItem (DRAWITEMSTRUCT& drawInfo);

protected:
	virtual void DrawText (TDC& dc, TRect& rc, DRAWITEMSTRUCT& drawInfo) = 0;

public:
	TODComboBox (TWindow* parent, int Id, int nLength, TModule* module = 0)
		: TComboBox (parent, Id, nLength, module) { }
};

class TFontNameList : public TODComboBox
{
	TFontList&	fontlist;
	TBitmap		bmpType;

protected:
	virtual void DrawText (TDC& dc, TRect& rc, DRAWITEMSTRUCT& drawInfo);

public:
	TFontNameList (TWindow* parent, int Id, TFontList& fonts, TModule* module = 0);
};

class TColorList : public TODComboBox
{
protected:
	virtual void DrawText (TDC& dc, TRect& rc, DRAWITEMSTRUCT& drawInfo);

public:
	TColorList (TWindow* parent, int Id, TModule* module = 0)
		: TODComboBox (parent, Id, 0, module) { }

	void		SetupWindow ();
};


// ---------------------------------------------------
// public definitions
// ---------------------------------------------------
class TFontData : public TChooseFontDialog::TData
{
public:
	TFontData ();
};

class TPrinterFontData : public TFontData
{
	TPrintDC		*pdc;
public:
	TPrinterFontData (TPrinter& printer);
	~TPrinterFontData ();
};

class TFontPropertyPage : public TPropertyPage
{
	TFontData&		fontdata;
	TFontList		fontlist;
	TFont			*ptFontSample;

	TFontNameList	*pcbFontName;
	TComboBox		*pcbFontStyle;
	TComboBox		*pcbFontSize;
	TColorList		*pcbColor;
	TSampleStatic	*peditSample;

	TIntArray		arrayBold;
	TIntArray		arrayItalic;
	int				nFontNameIndex;
	int				nFontPointSize10;

	void			FontSelected (TDC& dc, int nIndex);
	LRESULT			AfterSelection (WPARAM, LPARAM);
	void			EvAfterChange ()	{ PostMessage (WM_USER); }
	int				GetSelItem (TComboBox *ptList);

	void  			EvMeasureItem(UINT, MEASUREITEMSTRUCT far& measureInfo);

protected:
	virtual void	EvFontName ();
	virtual void	EvFontStyle ();
	virtual void	EvFontSize ();
	virtual void	EvColor ();

public:
	TFontPropertyPage (TResId resID, TFontData& fontdata, TModule *module = 0);
	~TFontPropertyPage ();

	virtual void	SetupWindow ();
	virtual BOOL	SaveData ();

	DECLARE_RESPONSE_TABLE (TFontPropertyPage);
};

#endif
