#ifndef PROGDDE_HXX
#define PROGDDE_HXX
#include <commonvu.hxx>

/**************************************************************************

Windows Program Manager features a DDE command-string interface that allows
other applications to create, display, and delete groups; add items to 
groups; and to close Program Manager. The following commands perform these
actions:
        o CreateGroup
        o AddItem
        o DeleteGroup
        o ShowGroup
        o ExitProgman

**************************************************************************/

/* Generic Message Handler */
class RecEvent : public Event
{
public:
    uint Message()  { return Event :: wMsg; }
    uint wParam()   { return Event :: wParam; }
    ulong lParam()  { return Event :: lParam; }
};

class ProgramManagerDDE : public TopAppWindow {
       unsigned int hWndClientDDE;            /* Our Handle */
       unsigned int hWndServerDDE;            /* Program Manager Handle */
       void ExecCommand(char *);              /* Command String Execution */
protected:
       long _loadds Dispatch ( Event );
public:
       ProgramManagerDDE();                   /* Connects to ProgMan */ 
       ~ProgramManagerDDE();                  /* Does Nothing for Now */  
       int CreateGroup(char *);               /* Adds a New Group */  
       int CreateGroup(char *, char *);
       int AddItem(char *);                   /* Adds a New Item */
       int AddItem(char *, char *);
       int AddItem(char *, char *, char *);
       int AddItem(char *, char *, char *, int);
       int AddItem(char *, char *, char *, int, int, int);
       int DeleteGroup(char *);               /* Deletes a Current Group */  
       int ShowGroup(char *, int);            /* Displays a Group */
       int ExitProgman(int);                  /* Exits Program Manager */
};

#endif

