#include "progdde.hxx"

extern "C" {
#include <string.h>
#include <stdio.h>

/* Windows Atom Functions */
unsigned int far pascal GlobalAddAtom(char *);
unsigned int far pascal GlobalDeleteAtom(unsigned int);

/* Windows Messaging Functions */
long far pascal SendMessage(int, unsigned int, unsigned int, long);
int far pascal  PostMessage(int, unsigned int, unsigned int, long);

/* Windows Global Memory Functions */
unsigned int far pascal GlobalAlloc(unsigned int, unsigned long);
unsigned int far pascal GlobalFree(unsigned int);
char * far pascal GlobalLock(unsigned int);
int far pascal    GlobalUnlock(unsigned int);
#define GMEM_MOVEABLE	    0x0002
#define GMEM_DDESHARE	    0x2000

/* DDE Definitions for Program Manager */
#define PROG_MAN_TOPIC "PROGMAN"        /* Program Manager Topic */
#define PROG_MAN_APP   "PROGMAN"        /* Program Manager Application */
#define EVERYBODY      -1               /* Address Message to all Windows */

/* Program Manager Execute Command Strings */
#define CREATEGROUP    "[CreateGroup("
#define SHOWGROUP      "[ShowGroup("
#define ADDITEM        "[AddItem("
#define DELETEGROUP    "[DeleteGroup("
#define EXITPROGMAN    "[ExitProgman("
#define COMMA          ","      
#define ENDCOMMAND     ")]"
#define ICONINDEX      "NNNNN"
#define XPOS           "NNNNN"
#define YPOS           "NNNNN"
#define SHOWCOMMAND    "NNNNN"
#define SAVESTATE      "N"

/* Dynamic Data Exchange Definitions */
#define WM_DDE_FIRST	    0x03E0
#define WM_DDE_INITIATE     (WM_DDE_FIRST)
#define WM_DDE_TERMINATE    (WM_DDE_FIRST+1)
#define WM_DDE_ACK	    (WM_DDE_FIRST+4)
#define WM_DDE_EXECUTE	    (WM_DDE_FIRST+8)

/* WinExec Definitions */
unsigned int far pascal WinExec(char *, unsigned int);
#define PROGRAM_MANAGER     "PROGMAN.EXE"
#define SW_SHOWNORMAL       1
#define EXEC_OK             32

#define MAKELONG(a, b)	    ((long)(((unsigned int)(a)) | ((unsigned long)((unsigned int)(b))) << 16))
}

ProgramManagerDDE :: ProgramManagerDDE()
{
  hWndClientDDE = 0;            /* No Current Conversation */
  hWndServerDDE = 0;

  unsigned int atomApplication, atomTopic;

  /* Create atom for DDE Conversation to Begin */
  atomApplication = GlobalAddAtom(PROG_MAN_APP);
  atomTopic       = GlobalAddAtom(PROG_MAN_TOPIC);

  hWndClientDDE = Handle();     /* Who we are */

  /* Ask Everybody about Conversing about Program Manager */                              
  SendMessage(EVERYBODY, WM_DDE_INITIATE, hWndClientDDE, 
                MAKELONG(atomApplication, atomTopic));

  /* If Nobody Answered, Try to Start Program Manager and Call Again */
  if (!hWndServerDDE) {
    if (WinExec(PROGRAM_MANAGER, SW_SHOWNORMAL) < EXEC_OK)
      return;
    SendMessage(EVERYBODY, WM_DDE_INITIATE, hWndClientDDE, 
                  MAKELONG(atomApplication, atomTopic));
    }

  /* Get Rid of The Conversation Atoms */
  GlobalDeleteAtom(atomApplication);
  GlobalDeleteAtom(atomTopic);
}

ProgramManagerDDE :: ~ProgramManagerDDE()
{
  PostMessage(hWndServerDDE, WM_DDE_TERMINATE, hWndClientDDE, 0L);

  hWndClientDDE = 0;            /* End Current Conversation */
  hWndServerDDE = 0;
}

void ProgramManagerDDE :: ExecCommand(char *szCommandString)
{
  HANDLE hCommand;
  char *lpCommand;

  if (!(hCommand = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, strlen(szCommandString) + 1)))
    return;
  if (!(lpCommand = GlobalLock(hCommand))) {    /* Lot's of Trouble */
    GlobalFree(hCommand);
    return;
    }
  strcpy(lpCommand, szCommandString);
  GlobalUnlock(hCommand);

  /* Send the Command String to Program Manager */                             
  if (!PostMessage(hWndServerDDE, WM_DDE_EXECUTE, hWndClientDDE,
              MAKELONG(0, hCommand)))
    GlobalFree(hCommand);               /* Problem, Free Our Own Data */
}

int ProgramManagerDDE :: CreateGroup(char *GroupName)
{
  return CreateGroup(GroupName, NULL);
}

int ProgramManagerDDE :: CreateGroup(char *GroupName, char *GroupPath)
{
  if (!hWndServerDDE)                   /* No Conversation Started */
    return 0;

  int CommandStringSize = strlen(CREATEGROUP) + strlen(GroupName) + strlen(COMMA) 
                    + strlen(GroupPath) + strlen(ENDCOMMAND) + 1;
  char *szCommandString = new char[CommandStringSize];

  strcpy(szCommandString, CREATEGROUP);         /* Build Create Group Command */
  strcat(szCommandString, GroupName);
  if (GroupPath) {
    strcat(szCommandString, COMMA);
    strcat(szCommandString, GroupPath);
    }
  strcat(szCommandString, ENDCOMMAND);

  ExecCommand(szCommandString);                 /* Execute the Command */

  delete szCommandString;
  return 1;
}

int ProgramManagerDDE :: AddItem(char *CmdLine)
{
  if (!hWndServerDDE)                   /* No Conversation Started */
    return 0;

  int CommandStringSize = strlen(ADDITEM) + strlen(CmdLine) 
                        + strlen(ENDCOMMAND) + 1;
  char *szCommandString = new char[CommandStringSize];

  strcpy(szCommandString, ADDITEM);         /* Build Add Item Command */
  strcat(szCommandString, CmdLine);
  strcat(szCommandString, ENDCOMMAND);

  ExecCommand(szCommandString);                 /* Execute the Command */

  delete szCommandString;
  return 1;
}

int ProgramManagerDDE :: AddItem(char *CmdLine, char *Name)
{
  if (!hWndServerDDE)                   /* No Conversation Started */
    return 0;

  int CommandStringSize = strlen(ADDITEM) + strlen(CmdLine) + strlen(COMMA) +
                        strlen(Name) + strlen(ENDCOMMAND) + 1;
  char *szCommandString = new char[CommandStringSize];

  strcpy(szCommandString, ADDITEM);         /* Build Add Item Command */
  strcat(szCommandString, CmdLine);
  strcat(szCommandString, COMMA);
  strcat(szCommandString, Name);
  strcat(szCommandString, ENDCOMMAND);

  ExecCommand(szCommandString);                 /* Execute the Command */

  delete szCommandString;
  return 1;
}

int ProgramManagerDDE :: AddItem(char *CmdLine, char *Name, char *IconPath)
{
  if (!hWndServerDDE)                   /* No Conversation Started */
    return 0;

  int CommandStringSize = strlen(ADDITEM) + strlen(CmdLine) + strlen(COMMA) +
                        strlen(Name) + strlen(COMMA) + strlen(IconPath) + 
                        strlen(ENDCOMMAND) + 1;
  char *szCommandString = new char[CommandStringSize];

  strcpy(szCommandString, ADDITEM);         /* Build Add Item Command */
  strcat(szCommandString, CmdLine);
  strcat(szCommandString, COMMA);
  strcat(szCommandString, IconPath);
  strcat(szCommandString, COMMA);
  strcat(szCommandString, ENDCOMMAND);

  ExecCommand(szCommandString);                 /* Execute the Command */

  delete szCommandString;
  return 1;
}

int ProgramManagerDDE :: AddItem(char *CmdLine, char *Name, char *IconPath, int IconIndex)
{
  if (!hWndServerDDE)                   /* No Conversation Started */
    return 0;

  int CommandStringSize = strlen(ADDITEM) + strlen(CmdLine) + strlen(COMMA) +
                        strlen(Name) + strlen(COMMA) + strlen(IconPath) + 
                        strlen(COMMA) + strlen(ICONINDEX) + 
                        strlen(ENDCOMMAND) + 1;
  char *szCommandString = new char[CommandStringSize];

  strcpy(szCommandString, ADDITEM);         /* Build Add Item Command */
  strcat(szCommandString, CmdLine);
  strcat(szCommandString, COMMA);
  strcat(szCommandString, IconPath);
  strcat(szCommandString, COMMA);
  sprintf(szCommandString, "%s%*d", szCommandString, strlen(ICONINDEX), IconIndex);
  strcat(szCommandString, COMMA);
  strcat(szCommandString, ENDCOMMAND);

  ExecCommand(szCommandString);                 /* Execute the Command */

  delete szCommandString;
  return 1;
}

int ProgramManagerDDE :: AddItem(char *CmdLine, char *Name, char *IconPath, int IconIndex, int xPos, int yPos)
{
  if (!hWndServerDDE)                   /* No Conversation Started */
    return 0;

  int CommandStringSize = strlen(ADDITEM) + strlen(CmdLine) + strlen(COMMA) +
                        strlen(Name) + strlen(COMMA) + strlen(IconPath) + 
                        strlen(COMMA) + strlen(ICONINDEX) + 
                        strlen(ENDCOMMAND) + 1;
  char *szCommandString = new char[CommandStringSize];

  strcpy(szCommandString, ADDITEM);         /* Build Add Item Command */
  strcat(szCommandString, CmdLine);
  strcat(szCommandString, COMMA);
  strcat(szCommandString, IconPath);
  strcat(szCommandString, COMMA);
  sprintf(szCommandString, "%s%*d", szCommandString, strlen(ICONINDEX), IconIndex);
  strcat(szCommandString, COMMA);
  strcat(szCommandString, ENDCOMMAND);

  ExecCommand(szCommandString);                 /* Execute the Command */

  delete szCommandString;
  return 1;
}

int ProgramManagerDDE :: DeleteGroup(char *GroupName)
{
  if (!hWndServerDDE)                   /* No Conversation Started */
    return 0;

  int CommandStringSize = strlen(DELETEGROUP) + strlen(GroupName) +
                        strlen(ENDCOMMAND) + 1;
  char *szCommandString = new char[CommandStringSize];

  strcpy(szCommandString, DELETEGROUP);         /* Build Delete Group Command */
  strcat(szCommandString, GroupName);
  strcat(szCommandString, ENDCOMMAND);

  ExecCommand(szCommandString);                 /* Execute the Command */

  delete szCommandString;
  return 1;
}

int ProgramManagerDDE :: ShowGroup(char *GroupName, int ShowCommand)
{
  if (!hWndServerDDE)                   /* No Conversation Started */
    return 0;

  int CommandStringSize = strlen(SHOWGROUP) + strlen(GroupName) + strlen(COMMA) +
                        strlen(SHOWCOMMAND) + strlen(ENDCOMMAND) + 1;
  char *szCommandString = new char[CommandStringSize];

  strcpy(szCommandString, SHOWGROUP);         /* Build Show Group Command */
  strcat(szCommandString, GroupName);
  strcat(szCommandString, COMMA);
  sprintf(szCommandString, "%s%*d", szCommandString, strlen(SHOWCOMMAND), ShowCommand);
  strcat(szCommandString, ENDCOMMAND);

  ExecCommand(szCommandString);                 /* Execute the Command */

  delete szCommandString;
  return 1;
}

int ProgramManagerDDE :: ExitProgman(int SaveState)
{
  if (!hWndServerDDE)                   /* No Conversation Started */
    return 0;

  int CommandStringSize = strlen(EXITPROGMAN) + strlen(SAVESTATE) +
                        strlen(ENDCOMMAND) + 1;
  char *szCommandString = new char[CommandStringSize];

  strcpy(szCommandString, EXITPROGMAN);         /* Build Exit Program Command */
  sprintf(szCommandString, "%s%*d", szCommandString, strlen(SAVESTATE), SaveState);
  strcat(szCommandString, ENDCOMMAND);

  ExecCommand(szCommandString);                 /* Execute the Command */

  delete szCommandString;
  return 1;
}

long _loadds ProgramManagerDDE :: Dispatch( Event e )
{
   switch (((RecEvent &)e ).Message ()) {
     case WM_DDE_ACK:           /* Process DDE Acknowledge */
       hWndServerDDE = ((RecEvent &) e).wParam();  
       return 0L;
       break;
     default:                   /* Send Message to Default Processing */
       return TopAppWindow :: Dispatch ( e );
       break;
     }
}

