/*************************************************************************/
/* Print an analysis of the profiler results.                            */
/*                                                                       */
/* (C) Copyright 1988, 1989 Diomidis D. Spinellis. All rights reserved.  */
/* See the file profprt.c for distribution details.                      */
/*                                                                       */
/* The code contained herein is not optimal. It is given as a substitute */
/* for a ten line awk script that had the same functionality.            */
/*                                                                       */
/* $Header: PROFPRT.C^v 1.1 88/11/20 17:36:12 dds Rel $                  */
/*                                                                       */
/* $Log:        PROFPRT.C^v $                                            */
/* Revision 1.1  88/11/20  17:36:12  dds                                 */
/* Initial revision                                                      */
/*************************************************************************/
#include <stdlib.h>
#include <stdio.h>

#define LINELEN 129 /* Profiler output maximum line length */
#define STRLEN  65  /* Linker output maximum symbol length */

char *Argv0;

static void usage(void)
{
   fprintf(stderr, "Usage : %s [-h] [file]", Argv0);
   exit(1);
}

int main(int argc, char *argv[])
{
FILE           *f;
long            t, total = 0, max = -1;
static char     line[LINELEN], str[STRLEN];
char           *fname = "prof.out";
int             histo = 0, fname_given = 0;
register        i;

   Argv0 = argv[0];

   while (argc > 1)
      switch (*argv[1]) {
         case '-': if (argv[1][1] == 'h') {
                      histo++;
                      argc--;
                      argv++;
                   } else
                      usage();
                   break;
         default:  if (fname_given)
                      usage();
                   else {
                      fname_given++;
                      fname = argv[1];
                      argc--;
                      argv++;
                   }
                   break;
      }

   if ((f = fopen(fname, "r")) == NULL) {
      perror(fname);
      return(1);
   }

   for (i = 1; fgets(line, LINELEN, f); i++) {
      if (sscanf(line, " %*s %ld ", &t) != 1) {
         fprintf(stderr, "%s : Error in reading %s(%d)\n", Argv0, fname, i);
         return(1);
      }

      total += t;
      if (t > max)
         max = t;
   }

   if (total == 0) {
      fprintf(stderr, "%s : No hits found\n", Argv0);
      return(1);
   }

   rewind(f);
   while (fgets(line, LINELEN, f)) {
      sscanf(line, " %s %ld ", str, &t);
      if (t) {
          printf("%-20s %5.2lf%% ", *str == '_' ? str + 1 : str,
                                    (double) t / (double) total * 100.0);
          if (histo)
             for (i = 0; i < (int) ((double) t / (double) max * 50); i++)
                putchar('*');
          putchar('\n');
      }
   }
   return(0);
}
