#include "pro.h"
#include "xglobals.h"
#include "vs.h"
#include "colors.h"
#include "mouse.h"
#include "video.h"
#include <conio.h>
#include <process.h>

int main()
{
	unsigned int window_handle[3], x, y, rhandle;
	int m1, m2, m3, m4, result;
	unsigned char rthandle;

	/*
	 * See tutors 1-3 for an explanation of this section.
	*/
	active_attr = white + (black << 4);
	inactive_attr = lightgray + (black << 4);
	active_tile_attr = lightgreen + (black << 4);
	inactive_tile_attr = red + (black << 4);
	scroll_bars_on = BOTH_BARS;
	thumbwheels_on = BOTH_BARS;
	wn_init();


	/*
	 * We'll use this window to make a backdrop for the other windows
	*/
	window_handle[0] = wn_createw(25,80,1,1,1,1,23,78,FALSE,NONE,NULL,NULL);
	vs_fillchar(window_handle[0],0,1,1,80,25, '', white, green);
	wn_openw(window_handle[0]);

	window_handle[2] = wn_createw(25,80,7,7,1,1,10,35,FALSE,HEAD_ON,"EXTRA WINDOW",NULL);
        vs_clrvs(window_handle[2], 0, white, black);
	wn_openw(window_handle[2]);

	window_handle[1] = wn_createw(25,80,5,5,1,1,15,30,FALSE,HEAD_ON,"MOUSE TUTORIAL",NULL);
	wn_openw(window_handle[1]);

	/*
	 * Determine if mouse hardware and software exist.
	 * kb_ismouse also resets the mouse internal registers.
	*/

	sprintf(buf,"kb_ismouse returns = %d.\n\n",kb_ismouse());
	vs_format(window_handle[1],0,white,black,buf);
	if (kb_ismouse()) vs_format(window_handle[1],0,white, black,
		"Great, you've got a mouse\ninstalled.....\n");
	else {
		vs_format(window_handle[1],0,white,black,
"Sorry, unless you've got a\n\
mouse installed we can't\n\
continue.\n");
		exit(0);
	}

	vs_format(window_handle[1],0, white, black, "\nPress any key to continue.");
	getch();

	/*
	 * Lesson 1:  Turning the mouse cursor on and off and
	 *	      Is the mouse on a window?
	*/

	/* Standard stuff..from previous tutortials */
	vs_locatecur(window_handle[1],0,1,1);
        vs_clrvs(window_handle[1], 0, white, black);
	vs_format(window_handle[1],0,white,black,
"Click on either window\n\
to activate it.\n\n\
Press any key to go on.\n");

	/* turn on the mouse cursor */
	kb_showmouse();

	/* We'll use a keypress to terminate this lesson */
	while (!kbhit()) {

		/*
		 * mouse status will return the status of the buttons
		 * in m2 (1 if left pressed, 2 if right pressed, 3 if
		 * both pressed.) and the location of the mouse cursor
		 * in m3 (x, 0-640) and m4 (y, 0-200).
		*/

		kb_mousestatus(&m2, &m3, &m4);

		/*
		 * Have to convert from a 0-640,0-200 to a 1-80,1-25 coord
		 * system.
		*/

		x = (m3/(640/80)) + 1;
		y = (m4/(200/25)) + 1;

		/*
		 * Note in our example the first window we created was actually
		 * a background for the other two windows.  The first window
		 * after calling wn_init always has a handle of 0.
		 *
		 * wn_isonwdw returns TRUE if the mouse cursor is on a window, otherwise
		 * it returns FALSE.  The handle of the window is returned in
		 * rhandle.
		*/

		if ((m2 != 0) && (wn_isonwdw(x, y, &rhandle))) {

			/* If it is not the background window then continue */
			if (rhandle > 0) {

				/*
				 * Always turn off the mouse cursor before
				 * updating the screen.  Otherwise the
				 * mouse software will sometimes interrupt
				 * the redraw operations at 'bad' points
				 * leaving 'mouse droppings :-).'
				*/

				kb_hidemouse();

				/*
				 * No need to open it if it is already on top
				*/
				if (rhandle != last_wdw) wn_openw(rhandle);

				/* And then turn it back on again */
				kb_showmouse();
			}
		}
	}
	/* clear the previous keypress */
	getch();

	/*
	 * Lesson 2 : Using wn_isonvs.
	 *
	 * wn_isonvs, is similar to wn_isonwdw, but only returns true if
	 * the mouse cursor is in the viewport of the specific window and
	 * tile.  If it is it transforms the
	 * coordinates to virtual screen logical coordinates.
	 *
	 * When calling wn_isonvs you must specify the window handle and
	 * tile handle of interest.  You have already seen how to get
	 * a window handle via wn_isonwdw.  You can use a similar function
	 * wn_isontile to determine the tile it is on, and then call
	 * wn_isonvs to determine if it is in the viewport and have the
	 * coordinates transformed.
	 *
	 * Let's say we want a system where we can move the logical cursor
	 * to a point on a virtual screen by placing the mouse there and
	 * clicking.
	 *
	*/

	/* Standard stuff... */
	wn_openw(window_handle[1]);
	vs_clrvs(window_handle[1],0,white,black);
	vs_locatecur(window_handle[1],0,1,1);
	vs_format(window_handle[1],0, white, black,
"Position mouse inside of\n\
window and click to move\n\
hardware cursor..\n\n\
Press any key to continue.\n");

	/* See below for explanation */
	kb_mousereleased(&m1, &m2, &m3, &m4);

	while (!kbhit()) {

	        /*
		 * kb_mousepressed reports information on mouse presses.
		 * You pass the button(s) of interest in m1 (1 = left, 2=
		 * right, 3 = both) and it returns the current status of
		 * the buttons in m1, the number of presses on the button
		 * of interest since the last call to kb_mousepressed.
		 * m3,m4 return the coordinates of the last button press.
		 *
		 * kb_mouserelease is identical, but returns information on
		 * mouse releases.
		 *
		 * Let's call a 'click' equivalent to a mouse release since
		 * you can't release a button until you've pressed.
		*/

		/* We are interested in the left button */
		m1 = 1;

		/* Has the left button been released? */
		kb_mousereleased(&m1, &m2, &m3, &m4);

		if (m2 > 0) {

			/*
			 * Transform from mouse coordinates to physical screen
			 * coordinates.
			*/

			x = (m3/8) + 1;
			y = (m4/8) + 1;

			/* Is it on a window? */
			if (wn_isonwdw(x,y,&rhandle)) {

				/*
				 * Is it something other than the background
				 * window ?
				*/

				if (rhandle > 0) {

					/*
					 * bring the window of interest to the top
					 * if it isn't already on top.
					*/
					if (rhandle != last_wdw) {

                                	        /* turn off the mouse cursor */
						kb_hidemouse();

						wn_openw(rhandle);

						/* turn the mouse cursor back on */
						kb_showmouse();
					}

					/* find out what tile the mouse is in */
					wn_isontile(rhandle, &rthandle, x, y);

					/*
					 * Is it in a viewport?
					 * If yes, relocate the logical cursor.
					 */

					if (wn_isonvs(rhandle, rthandle, &x, &y))  {
						vs_locatecur(rhandle, rthandle, x, y);
					}
				}
			}
		}
	}
	/* clear the last keypress */
	getch();

	/*
	 * Lesson 3: Sensing points on the window border and using kb_mouseclicks
	 *
	 * You can make points on the border of a window have functional
	 * significance.  For example, you might say that the upper left
	 * corner can be 'grabbed' and used to move a window and the
	 * lower right corner can be grabbed and used to resize a window.
	 *
	 * Perhaps double-clicking on a window zooms it and single clicking
	 * positions the hardware cursor.
	 *
	 * Once you have determined that a point is on a window you can
	 * find out if it is in the border with functions like, wn_isonulc
	 * (is it on the upper left corner?) and wn_isonlrc (is it on the
	 * lower right corner?).  There are several of these -- see the
	 * reference manual for a complete list.
	*/

	/* Standard stuff... */
	wn_openw(window_handle[1]);
	vs_clrvs(window_handle[1],0,white,black);
	vs_locatecur(window_handle[1],0,1,1);
	vs_format(window_handle[1],0, white, black,
"Double click to zoom.\n\
Click to move hardware cursor.\n\
Grab upper left corner to drag.\n\
Grab lower right corner to size.\n\
Press or click scroll bars to\n\
  scroll virtual screen.\n\n\
Press any key or click\n\
on window name to continue.\n");


	while (!kbhit()) {

		/*
		 * kb_mouseclicks is a simpler function to use than
		 * the other button sensing functions.
		 * However, it does not provide as much control.
		 * It returns
		 * DOUBLECLICK for a double-click,
		 * CLICK for a single-click,
		 * PRESS for a button-press, and
		 * RELEASE for a button-release.
		 *
		 * BUTTON should be 1 for the left and 2 for the right.
		 * TIMEOUT sets the mouse sensitivity.  It is actually the
		 * the number of times kb_mouseclicks iterates through its
		 * main loop without sensing any mouse activity.  As such
		 * it is a processor dependent routine. (Maybe we'll fix that
		 * later on.)
		*/

		#define BUTTON		1
		#define TIMEOUT		15

		/* check the mouse */
		result = kb_mouseclicks(BUTTON, TIMEOUT, &x, &y);

		/* convert the coordinates */
		x /= 8;
		y /= 8;
		x++;
		y++;

		/*
		 * If there was a button event and we are on a window and
		 * it is not the background window, then we better do something
		 * about it.
		*/

                if ( (result) && (wn_isonwdw(x, y, &rhandle)) && (rhandle > 0)) {

			/*
			 * First let's bring that window to the top of
			 * the screen if it isn't already there
			*/

			if (rhandle != last_wdw) {
				kb_hidemouse();
				wn_openw(rhandle);
				kb_showmouse();
			}

			/*
			 * If this is a PRESS let's investigate further */
			if ((result == PRESS) || (result == HOLDING)) {

				/*
				 * If it is on the upper left corner then
				 * move the window until we release the button
				*/

				if (wn_isonulc(rhandle, x, y)) {

					m2 = 1;

					/* While left button is pressed --- */
					while (m2 == 1) {
						/*
						 * we have to get the current location of the cursor
						 * because kb_mouseclicks only gives us the
						 * location of the cursor at the last button event.
						 * and this routine is predicated on their not being
						 * an event.  In addition we use kb_mousestatus to
						 * to look for the release of the key because it
						 * doesn't use the timeout approach (which slows down
						 * the response and makes the window lag behind the mouse
						 * cursor.)
						*/
						kb_mousestatus(&m2, &m3, &m4);

						/* convert the coordinates */
						x = (m3/8) + 1;
						y = (m4/8) + 1;

						/*
						 * If window is in a different position
						 * then the mouse cursor, move the window
						*/
						if ((wdw[rhandle]->physical_x != x) ||
							(wdw[rhandle]->physical_y != y)) {
							kb_hidemouse();
							wn_locatew(rhandle, x, y);
							kb_showmouse();
						}
					}
				}

				/*
				 * Same as for moving except we size the window
				*/
				else if (wn_isonlrc(rhandle, x, y)) {
					m2 = 1;
					while (m2 == 1) {
						kb_mousestatus(&m2, &m3, &m4);
						x = (m3/8) + 1;
						y = (m4/8) + 1;
						if (((wdw[rhandle]->physical_x +
							wdw[rhandle]->port_columns + 1)
							!= x) ||
							((wdw[rhandle]->physical_y +
							wdw[rhandle]->port_rows + 1)
							!= y)) {
							kb_hidemouse();
							wn_sizet(rhandle,
								wdw[rhandle]->last_tile,
								x - wdw[rhandle]->physical_x -
								wdw[rhandle]->port_columns - 1, y -
								wdw[rhandle]->physical_y -
								wdw[rhandle]->port_rows - 1);
							kb_showmouse();
						}
					}
				}

				/* We handle the scroll bars in the same way */
                                else if (wn_isonsbd(rhandle, 0, x, y)) {
					m2 = 1;
					while (m2 == 1) {
						kb_mousestatus(&m2, &m3, &m4);
						kb_hidemouse();
						wn_scrollvs(rhandle,0,0,1);
						kb_showmouse();
						wn_sync_tw_to_vs(rhandle, 0);
					}
				}
                                else if (wn_isonsbr(rhandle, 0, x, y)) {
					m2 = 1;
					while (m2 == 1) {
						kb_mousestatus(&m2, &m3, &m4);
						kb_hidemouse();
						wn_scrollvs(rhandle,0,1,0);
						kb_showmouse();
						wn_sync_tw_to_vs(rhandle, 0);
					}
				}
                                else if (wn_isonsbl(rhandle, 0, x, y)) {
					m2 = 1;
					while (m2 == 1) {
						kb_mousestatus(&m2, &m3, &m4);
						kb_hidemouse();
						wn_scrollvs(rhandle,0,-1,0);
						kb_showmouse();
						wn_sync_tw_to_vs(rhandle, 0);
					}
				}
                                else if (wn_isonsbu(rhandle, 0, x, y)) {
					m2 = 1;
					while (m2 == 1) {
						kb_mousestatus(&m2, &m3, &m4);
						kb_hidemouse();
						wn_scrollvs(rhandle,0,0,-1);
						kb_showmouse();
						wn_sync_tw_to_vs(rhandle, 0);
					}
				}
       			else if (wn_isonvtw(rhandle, 0, x, y)) {
					kb_mousestatus(&m2, &m3, &m4);
					while (m2 == 1) {
						y = m4/(200/physical_rows) + 1;
						y = y - (wdw[rhandle]->physical_y + 2);
						kb_hidemouse();
						wn_locatetwabs(rhandle, 0, -1, y);
						wn_sync_vs_to_tw(rhandle, 0);
						kb_showmouse();
						kb_mousestatus(&m2, &m3, &m4);
					}
				}
  				else if (wn_isonhtw(rhandle, 0, x, y)) {
					kb_mousestatus(&m2, &m3, &m4);
					while (m2 == 1) {
						x = m3/(640/physical_columns) + 1;
						kb_hidemouse();
						x = x - (wdw[rhandle]->physical_x + 2);
						wn_locatetwabs(rhandle, 0, x, -1);
						wn_sync_vs_to_tw(rhandle, 0);
						kb_showmouse();
						kb_mousestatus(&m2, &m3, &m4);
					}
				}
	                        else if (wn_isonvrbar(rhandle, 0, x, y)) {
					y = y - (wdw[rhandle]->physical_y + 2);
					wn_locatetwabs(rhandle, 0, -1, y);
					wn_sync_vs_to_tw(rhandle, 0);
				}
                                else if (wn_isonhbar(rhandle, 0, x, y)) {
					x = x - (wdw[rhandle]->physical_x + 2);
					wn_locatetwabs(rhandle, 0, x, -1);
					wn_sync_vs_to_tw(rhandle, 0);
				}
			}

			/* If its a double-click in the viewport the zoom it */
			else if ((result == DOUBLECLICK) && (wn_isonvs(rhandle, 0, &x, &y))) {
				kb_hidemouse();
				wn_zoomw();
				kb_showmouse();
			}

			/* If it is a single-click we've got different choices */
			else if (result == CLICK) {

				/*
				 * if it is in a virtual screen move the
				 * screen's cursor.
				*/
				if (wn_isonvs(rhandle,0,&x,&y))
					vs_locatecur(rhandle,0,x,y);

				/*
				 * If it is on a window name -- exit
				*/
				else if (wn_isonnamew(rhandle,x,y)) {

					/* restore the background screen */
				        wn_restorescr();

					/* restore the cursor position */
					v_gotoxy(oldx,oldy);

					/* restore the cursor shape */
					v_curshape(oldb, olde);

					exit(0);
				}

				/* We handle single clicks on scroll bars in the same way */
                                else if (wn_isonsbu(rhandle, 0, x, y)) {
					wn_scrollvs(rhandle,0,0,1);
				}
                                else if (wn_isonsbl(rhandle, 0, x, y)) {
					wn_scrollvs(rhandle,0,1,0);
				}
                                else if (wn_isonsbr(rhandle, 0, x, y)) {
					wn_scrollvs(rhandle,0,-1,0);
				}
                                else if (wn_isonsbd(rhandle, 0, x, y)) {
					wn_scrollvs(rhandle,0,0,-1);
				}
                                else if (wn_isonvrbar(rhandle, 0, x, y)) {
					y = y - (wdw[rhandle]->physical_y + 2);
					wn_locatetwabs(rhandle, 0, -1, y);
					wn_sync_vs_to_tw(rhandle, 0);
				}
                                else if (wn_isonhbar(rhandle, 0, x, y)) {
					x = x - (wdw[rhandle]->physical_x + 2);
					wn_locatetwabs(rhandle, 0, x, -1);
					wn_sync_vs_to_tw(rhandle, 0);
				}
			}
		}
	}
	getch();

	/*

	/* restore the background screen */
        wn_restorescr();

	/* restore the cursor position */
	v_gotoxy(oldx,oldy);

	/* restore the cursor shape */
	v_curshape(oldb, olde);

}
