#include <dos.h>
#include <stdio.h>

#define WDW 			wdw[handle]
#define TILE 			wdw[handle]->tiles[tile_handle]
#define A_WDW 			wdw[active_wdw]
#define A_TILE 			wdw[active_wdw]->tiles[wdw[active_wdw]->active_tile]
#define VID_ACCESS 		((inp(0x03DA) & 0x01) == 0x01)
#define RETRACE 		((inp(0x03DA) & 0x08) == 0x08)
#define DMA				1
#define BIOS			2
#define ANSI			3
#define ERROR(errnum, functnum)	{wn_errorhandler(errnum,functnum); return(errnum);}
#define upcase(ch)		(((ch >=97) && (ch <=122)) ? ch - 32 : ch)

#define TRUE 				1
#define FALSE 				0
#define MAX_WINDOWS 		256
#define MAX_TILES 			10
#define UPPER_LEFT			1
#define UPPER_RIGHT			2
#define LOWER_LEFT			3
#define LOWER_RIGHT			4
#define HEAD_ON				5
#define NONE				0
#define NO_BARS				0
#define HORIZONTAL_BAR		1
#define VERTICAL_BAR		2
#define	BOTH_BARS			3
#define LEFT_JUSTIFY		0
#define CENTER_JUSTIFY		1
#define RIGHT_JUSTIFY		2

/* standard return codes */
#define ABORTED								1
#define CONFIRMED    						2
#define ASCENDED							3
#define DESCENDED							4
#define MOUSED								5
#define EXIT1								6
#define EXIT2								7
#define EXIT3								8
#define EXIT4								9
#define EXIT5								10
#define MENUED								11


/* screen char record */
typedef struct {
	unsigned char character;
	unsigned char attribute;
} screen_char;

/* tile record */
typedef struct {
	screen_char far *virtual_screen;
	char *tile_name;
	unsigned char forward, backward, scroll_bars, thumbwheel,
		suspend, border_color;
	int hide, port_rows, vs_rows, vs_columns,
		cursor_x, cursor_y, virtual_x, virtual_y, offset_y;
	double vertical_thumb, horizontal_thumb;
	char justify;
	void *resource;
} tile_rec;

/* wdw record */
typedef struct {
	unsigned physical_x, physical_y, suspend, hide, border,
		forward, backward;
	unsigned char first_tile, last_tile, active_tile;
	int port_columns, port_rows;
	unsigned char border_color, *border_chars;
	char *wdw_name;
	tile_rec far *tiles[MAX_TILES + 1];
	char justify;
	void *resource;
} wdw_rec;


/* block record */
typedef struct {
	unsigned x, y, rows, columns;
	screen_char far *buffer;
} blkrec;

#define SCR_SIZE 		(physical_rows * physical_columns * sizeof(screen_char))

/* Window and tile manipulation functions */
extern void 	wn_errorhandler(signed int, signed int);
extern int 		wn_delt(unsigned, unsigned char);
extern int 		wn_actt(unsigned, unsigned char);
extern int 		wn_updatew(unsigned);
extern int 		wn_updatet(unsigned, unsigned char);
extern int 		wn_closet(unsigned, unsigned char);
extern int 		wn_openw(unsigned);
extern void 	wn_flybox(int, int, int, int, int, int, int, int,
				unsigned, unsigned, unsigned char *, unsigned char,
				unsigned char);
extern void 	wn_flyboxfilled(int, int, int, int, int, int, int, int,
				unsigned, unsigned, unsigned char *, unsigned char,
				unsigned char, unsigned char, unsigned char);
extern int 		wn_delw(unsigned);
extern void		wn_freeze(void);
extern void 	wn_defrost(unsigned, unsigned, unsigned,
				unsigned);
extern int		wn_init(void);
extern int		wn_suspendw(unsigned);
extern int		wn_actw(unsigned);
extern void		wn_redraw(void);
extern int		wn_draww(unsigned);
extern int		wn_movew(unsigned, signed int, signed int);
extern int		wn_locatew(unsigned, signed int, signed int);
extern int		wn_zoomw(void);
extern int		wn_createw(unsigned, unsigned, unsigned,
				unsigned, unsigned, unsigned, unsigned,
				unsigned, unsigned, unsigned, char *, char *);
extern int		wn_createt(unsigned, char *, unsigned, unsigned,
				unsigned, unsigned);
extern int		wn_suspendt(unsigned, unsigned char);
extern int		wn_opent(unsigned, unsigned char);
extern int		wn_scrollvs(unsigned, unsigned char,  signed int,
				signed int);
extern int 		wn_sizet(unsigned, unsigned char, signed int,
				signed int);
extern int		wn_namew(unsigned, char *);
extern int		wn_namet(unsigned, unsigned char, char *);
extern int		wn_chgbord(unsigned, unsigned char *);
extern int		wn_closew(unsigned);
extern int		wn_hidew(unsigned);
extern int		wn_swapt(unsigned, unsigned char, unsigned,
				unsigned char);
extern int		wn_togborder(unsigned, unsigned char);
extern void		wn_restorescr(void);
extern void		wn_savescr(void);
extern int		wn_locatevs(unsigned, unsigned char, signed int,
				signed int);
extern int		wn_moverng(unsigned, unsigned, signed int,
				signed int);
extern int		wn_chgbordrng(unsigned, unsigned, unsigned char *);
extern int		wn_sizerng(unsigned, unsigned, signed int,
				signed int);
extern int		wn_chgcolor(unsigned, unsigned char,
				unsigned char);
extern int		wn_chgcolorrng(unsigned, unsigned, unsigned char,
				unsigned char);
extern int		wn_togbordrng(unsigned, unsigned, unsigned char);
extern void		wn_hidecur(void);
extern void		wn_showcur(void);
extern unsigned	wn_isonwdw(unsigned, unsigned, unsigned *);
extern int 		wn_togscrollrng(unsigned, unsigned, unsigned char);
extern int 		wn_togscroll(unsigned, unsigned char, unsigned char);
extern int		wn_isontile(unsigned, unsigned char *, unsigned,
				unsigned);
extern int		wn_isonsbl(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_isonsbr(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_isonsbu(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_isonsbd(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_isonvlbar(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_isonvrbar(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_isonhbar(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_isonvs (unsigned, unsigned char, unsigned *,
				unsigned *);
extern int		wn_isonurc(unsigned, unsigned, unsigned);
extern int		wn_isonulc(unsigned, unsigned, unsigned);
extern int		wn_isonlrc(unsigned, unsigned, unsigned);
extern int		wn_isonllc(unsigned, unsigned, unsigned);
extern int		wn_isonubar(unsigned, unsigned, unsigned);
extern int		wn_isonlbar(unsigned, unsigned, unsigned);
extern int		wn_isonrelb(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_isonlelb(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_isonnamew(unsigned, unsigned, unsigned);
extern int		wn_isonnamet(unsigned, unsigned char, unsigned,
				unsigned);
extern int      wn_isonhtw(unsigned, unsigned char, unsigned,
				unsigned);
extern int      wn_isonvtw(unsigned, unsigned char, unsigned,
				unsigned);
extern int		wn_whereon(unsigned *, unsigned char *, unsigned *,
				unsigned *);
extern int		wn_edlin(unsigned, unsigned char, char **, char,
				int, int, int, int, int, unsigned char, unsigned char,
				int *);
extern int		vs_format(unsigned, unsigned char, unsigned char,
				unsigned char, char *);
extern int 		wn_togscrollallt(unsigned, unsigned char);

/* release 1.3 functions */
extern int		wn_movetwrel(unsigned, unsigned char, double, double);
extern int		wn_movetwabs(unsigned, unsigned char, int, int);
extern int		wn_locatetwrel(unsigned, unsigned char, double, double);
extern int		wn_locatetwabs(unsigned, unsigned char, signed int, signed int);
extern int		wn_sync_vs_to_tw(unsigned, unsigned char);
extern int		wn_sync_tw_to_vs(unsigned, unsigned char);
extern int		wn_togthumb(unsigned, unsigned char, unsigned char);

/* release 1.4 functions */
extern int 		wn_copyw(unsigned);
extern int 		wn_copyt(unsigned, unsigned char, unsigned);
extern int		wn_openabst(unsigned, unsigned char, unsigned);
extern int		wn_openrelt(unsigned, unsigned char, double);
extern int 		wn_delrng(unsigned, unsigned);
extern int 		wn_closerng(unsigned, unsigned);
extern int 		wn_swapw(unsigned, unsigned);
extern int 		wn_swapt2(unsigned, unsigned char, unsigned char);
extern int 		wn_putslist(char *[], unsigned char, unsigned char, int,
				int, int, char *, char*);

/* release 1.51 functions */
extern int		wn_draww_on_vs(unsigned, unsigned, unsigned char);
