#if !defined(__apxprev_h)               // Sentry, use file only if it's not already included.
#define __apxprev_h

/*
	 FILE:         APXPrev.H


	 OVERVIEW
	 ========
	 Class definition for PreviewWindow (Print Preview) generated by AppExpert
	 with modifications by Walter C. Riley.
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\printer.h>
#include <owl\controlb.h>
#include <owl\printdia.h>
#include <owl\preview.h>
#include <owl\scroller.h>

// You will need to change this appropriately
#include "xxxapp.rh"

//{{TDecoratedFrame = PreviewWindow}}
class PreviewWindow : public TDecoratedFrame {
public:
	 PreviewWindow (TWindow *parentWindow, TPrinter *printer, TPrintout* printout, TWindow* currWindow, const char far* title, TLayoutWindow* client);
	 ~PreviewWindow ();

	 int             PageNumber;

	 TWindow         *CurrWindow;
	 TControlBar     *PreviewSpeedBar;
	 TPreviewPage    *Page1;
	 TPreviewPage    *Page2;
	 TPrinter        *Printer;

	 TPrintDC        *PrnDC;
	 TSize           *PrintExtent;
//  I totally eliminated all reference to APXPrintOut and removed from my project
//    APXPrintOut     *Printout;
	 TPrintout       *Printout;

private:
	 TLayoutWindow   *Client;

	 void SpeedBarState ();

//{{PreviewWindowVIRTUAL_BEGIN}}
protected:
	 virtual void SetupWindow ();
//{{PreviewWindowVIRTUAL_END}}

//{{PreviewWindowRSP_TBL_BEGIN}}
protected:
	 void Initialize();
	 void PPR_Previous ();
	 void PPR_Next ();
	 void PPR_OneUp ();
	 void PPR_TwoUp ();
// added these to the expert code
	 void PPR_ZoomIn ();
	 void PPR_ZoomOut ();
	 void EvNCLButtonDown (UINT wHitTestCode, TPoint & point);
	 void EvClose ();
    int  scrollerYRange;
//{{PreviewWindowRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(PreviewWindow);
};    //{{PreviewWindow}}


#endif      // __apxprev_h sentry.
