/*
 *
 * Printer.h
 *
 * Copyright 1993 Burghart Technology Systems. All Rights Reserved.
 *
 * Description:
 *
 *   printInit - initialize the given printer port
 *   printStat - return the status of the given port
 *   printChar - send one character to the given port
 *
 *   printBits - translates bits returned by printer interrupt
 *               (i.e. biosprint) into prnStatus enum
 *
 * Revision History:
 *
 *  Date        By                Purpose
 *  ----        --                -------
 *
 *  08/17/1993  Ted Burghart      Original File
 */

#ifndef __PRINTER_H
#define __PRINTER_H

#ifdef __cplusplus
#define EXC extern "C"
#else
#define EXC extern
#endif

#ifdef __cplusplus
enum prnStatus {
#else
typedef enum {
#endif
                prnOK,
                prnSuccess=prnOK,
                prnNotSelected,
                prnOutOfPaper,
                prnBusy,
                prnTimeOut,
                prnNotConnected,
                prnInvalidPort
#ifdef __cplusplus
};
const prnNumPorts = 4;
#else
} prnStatus;
#define prnNumPorts 4
#endif

EXC prnStatus _cdecl printInit( unsigned short _port );
EXC prnStatus _cdecl printStat( unsigned short _port );
EXC prnStatus _cdecl printChar( unsigned short _port, char _char );

EXC prnStatus _cdecl printBits( unsigned short _bits );

#ifdef __cplusplus
class PrinterPort
{
    unsigned short pp;

public:

    PrinterPort( unsigned short _port ) : pp( _port ) {}

    prnStatus      init() const           { return printInit( pp ); }
    prnStatus      stat() const           { return printStat( pp ); }
    prnStatus      send( char _ch ) const { return printChar( pp, _ch ); }
    unsigned short port() const           { return pp; }
};
#endif

#endif    /* __PRINTER_H    */

