//
//
// Prn_Stat.cpp
//
// Copyright 1993 Burghart Technology Systems. All Rights Reserved.
//
// Description:
//
//
//
// Revision History:
//
//  Date        By                Purpose
//  ----        --                -------
//
//  08/16/1993  Ted Burghart      Original File

#ifndef __cplusplus
#error This file requires a C++ compiler
#endif

#define DISPLAYSTATUS 1

#ifndef __BIOS_H
#include <bios.h>
#endif

#ifndef __CONIO_H
#include <conio.h>
#endif

#ifndef __IOSTREAM_H
#include <iostream.h>
#endif

#ifndef __STDLIB_H
#include <stdlib.h>
#endif

#ifndef __STRING_H
#include <string.h>
#endif

#if DISPLAYSTATUS
#ifndef __PRINTER_H
#include "Printer.h"
#endif
#endif // DISPLAYSTATUS

struct
{
   int      x, y, l, mask;
   char   * s;
}
   label[] = {
               { 0, 0, 0, 0x10, "Selected" },
               { 0, 0, 0, 0x20, "Out of Paper" },
               { 0, 0, 0, 0x01, "Time Out" },
               { 0, 0, 0, 0x08, "I/O Error" },
               { 0, 0, 0, 0x40, "Acknowledge" },
               { 0, 0, 0, 0x80, "Not Busy" }
             };

const nLabels = (sizeof(label)/sizeof(label[0]));

char * lpt[] = { "LPT1", "LPT2", "LPT3", "LPT4" };

#if DISPLAYSTATUS
char  * status[] = {
                     "Ready",
                     "Not Selected",
                     "Out of Paper",
                     "Busy",
                     "Time Out",
                     "Not Connected",
                     "Invalid Port",
                   };
#define DLINES 5
#else
#define DLINES 3
#endif // DISPLAYSTATUS

void main( int argc, char ** argv )
{
   _setcursortype(_NOCURSOR);
   unsigned port = 0;
   if ( argc > 1 )
   {
      unsigned p = (atoi( argv[1] ) - 1);
      if ( p < 4 )
         port = p;
   }
   int mLen = 0;
   for ( int i = 0; i < nLabels; i++ )
      if ( (label[i].l = strlen(label[i].s)) > mLen )
         mLen = label[i].l;
   cout << "\n\tPort: " << lpt[port] << "\n";
   for ( i = 0; i < nLabels; i++ )
   {
      cout << "\n\t";
      for ( int l = (mLen - label[i].l); l > 0; l-- )
         cout << "\x20";
      cout << label[i].s << ":\x20";
      label[i].x = wherex();
   }
   #if DISPLAYSTATUS
   cout << "\n\n\t";
   for ( int l = (mLen - (sizeof("Status")-1)); l > 0; l-- )
      cout << "\x20";
   cout << "Status:\x20";
   int sttx = wherex();
   #endif // DISPLAYSTATUS
   cout << "\n\n\tPress any key to exit.\n";
   int endx = wherex();
   int endy = wherey();
   int pos = (endy - DLINES - nLabels);
   #if DISPLAYSTATUS
   int stty = (endy - 3);
   #endif // DISPLAYSTATUS
   for ( i = 0; i < nLabels; i++ )
      label[i].y = ++pos;
   int lastBits = -1, lastStat = -1;
   while ( !kbhit() )
   {
      int pbits = biosprint( 2, 0, port );
      if ( pbits != lastBits )
      {
         lastBits = pbits;
         for ( i = 0; i < nLabels; i++ )
         {
            gotoxy( label[i].x, label[i].y );
            cputs( (pbits & label[i].mask) ? "On " : "Off" );
         }
      }
      #if DISPLAYSTATUS
      prnStatus pstat = printStat( port );
      if ( pstat != lastStat )
      {
         lastStat = pstat;
         gotoxy( sttx, stty );
         clreol();
         cputs( status[pstat] );
      }
      #endif // DISPLAYSTATUS
   }
   if ( !getch() )
      getch(); // clear keystroke
   gotoxy( endx, endy );
   _setcursortype(_NORMALCURSOR);
}
