/*
 *
 * Prn_Bits.c
 *
 * Copyright 1993 Burghart Technology Systems. All Rights Reserved.
 *
 * Description:   Translates bits returned by printer interrupt
 *                into prnStatus enum.
 *
 * Revision History:
 *
 *  Date        By                Purpose
 *  ----        --                -------
 *
 *  08/17/1993  Ted Burghart      Original File
 */

#include "Printer.h"

enum
{
   flgBusy     = 0x80,
   flgAck      = 0x40,
   flgPaperOut = 0x20,
   flgNotSel   = 0x10,
   flgIOError  = 0x08,
   flgTimeOut  = 0x01
};

prnStatus _cdecl printBits( unsigned short _bits )
{
   register int       b = ((_bits & 0xF9) ^ (flgBusy | flgNotSel));
   register prnStatus r = prnOK;
   if ( b & ~flgAck )
   {
      if ( b & flgPaperOut )
         r = prnOutOfPaper;
      else if ( (b & (flgAck | flgNotSel)) == flgNotSel )
         r = prnNotSelected;
      else if ( b & flgTimeOut )
         r = prnTimeOut;
      else if ( b & flgIOError )
         r = prnNotConnected;
      else if ( b & flgBusy )
         r = prnBusy;
   }
   return r;
}
