;;
;;
;; Printer.asm
;;
;; Copyright 1993 Burghart Technology Systems. All Rights Reserved.
;;
;; Description:
;;
;;
;;
;; Revision History:
;;
;;  Date        By                Purpose
;;  ----        --                -------
;;
;;  08/17/1993  Ted Burghart      Original File

Ideal

Include "Printer.inc"

CodeSeg

Proc NoLanguage getStat Near

               mov   ax,0200h
               int   17h

Proc NoLanguage transAX Near

               xor   al,al
               xchg  ah,al
               xor   al,(flgBusy OR flgNotSel)
               test  al,(NOT (flgAck OR flgBusy))
               jnz   @@Error
               xor   al,al
               ret
@@Error:
               test  al,flgPaperOut
               jz   @@paperOK
               mov   al,prnOutOfPaper
               ret
@@paperOK:
               test  al,flgNotSel
               jz   @@selected
               test  al,flgAck
               jnz   @@selected
               mov   al,prnNotSelected
               ret
@@selected:
               test  al,flgTimeOut
               jz   @@timeOK
               mov   al,prnTimeOut
               ret
@@timeOK:
               test  al,flgIOError
               jz   @@NoErr
               mov   al,prnNotConnected
               ret
@@NoErr:
               test  al,flgBusy
               jz   @@NotBusy
               mov   al,prnBusy
               ret
@@NotBusy:
               xor   al,al
               ret
EndP
EndP

PrintProc printInit

               mov   ax,0100h
               int   17h
               call  transAX
@@GetOut:
               ret
EndP

PrintProc printStat

               call  getStat
@@GetOut:
               ret
EndP

PrintProc printChar

               call  getStat
               or   al,al
               jnz   @@GetOut
               xor   ax,ax
               mov   al,[_char]
               int   17h
               call  transAX
@@GetOut:
               ret
EndP

EndS

;; Note: No END directive in this file
;;
;;  This file is included into the print_fo.asm and print_no.asm files
;;  which set the memory model and include the END directive
