#define Uses_TApplication
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TKeys
#define Uses_TEvent
#define Uses_TFileDialog
#define Uses_TDeskTop
#define Uses_MsgBox
#include <tv.h>

#include "PrintApp.h"

const
	cmPrintFile = 100;

class TApp : public TPrintApp
	{
	public:

		TApp();

		virtual void handleEvent(TEvent&);

		static TMenuBar* initMenuBar(TRect);
	};

TApp::TApp() : TProgInit(initStatusLine, initMenuBar, initDeskTop),
			   TPrintAppInit(initPrintQueue)
	{}

void TApp::handleEvent(TEvent& event)
	{
	TPrintApp::handleEvent(event);

	if(event.what == evCommand && event.message.command == cmPrintFile)
		{
		TFileDialog* dlg = new TFileDialog("*.*", "Print A File", "~N~ame",
			fdOKButton, 101);
		if(validView(dlg) != 0)
			{
			if(deskTop->execView(dlg) == cmFileOpen)
				{
				char fspec[170];
				dlg->getFileName(fspec);
				if(!message(this, evCommand, cmAddPrintJob, new PrintFile(fspec, 128)))
					messageBox("Can't print that file", mfError|mfOKButton);
				}
			destroy(dlg);
			}
		clearEvent(event);
		}
	}

TMenuBar* TApp::initMenuBar(TRect r)
	{
	r.b.y = r.a.y+1;
	return new TMenuBar(r,
		*new TSubMenu("~F~ile", 0)+
			*new TMenuItem("~P~rint a file...", cmPrintFile, kbNoKey, hcNoContext, 0)+
			newLine()+
			*new TMenuItem("E~x~it", cmQuit, kbAltX, hcNoContext, "Alt-X")
		);
	}

int main()
	{
	TApp app;

	if(app.valid(cmValid))
		app.run();
	app.shutDown();
	return 0;
	}
