               /*Ŀ
                                                                        
                    prntinst = installs graphics print screen routine   
                               to replace the original print screen     
                               routine.                                 
                                                                        
                 */

#include <dos.h>


void interrupt print_handler()
{
	unsigned char background;
        int i,x;

	void put_out(char character);

	put_out(0x1b);
	put_out(0x33);
	put_out(0x15);
        for (i=0; i<12; i++)
		put_out(0x0A);
        background = readPixel(0,0);
	for (x=319; x>=3; x-=4)
        	printrow(x,background);
        put_out('\x0C');
}



printrow(int x,int background)
{
	unsigned char savechar,temp;
        unsigned char out_buff[485]={"\x1b*\x5\xE0\x01"};
	int i, j, newy,y;

	char status();
	void put_out();

	for (y=0,j=85; y<=199; y++,j+=2)
	{
		savechar = 0;
		for (i=0; i<4; i++)
		{
			temp = readPixel(x-i,y);
			if (temp != background)
				savechar |= 0x03;
			if (i!=3)
				savechar <<= 2;
		}
		out_buff[j] = savechar;
		out_buff[j+1] = savechar;
	 }
	for (i=0; i<485; i++)
	{
		put_out(out_buff[i]);
	}
	put_out('\r');
	put_out('\n');
}

char status()
{
	char temp;
	temp = inportb(0x379);
	return (temp & 0x80);
}


void put_out(char character)
{
	int temp;
	
	while (!status());
	outportb(0x378,character);
	outportb(0x37A,0x0D);
	outportb(0x37A,0x0C);
}


int readPixel (int x, int y)
{	
	char mask;
	int color;
	unsigned int offset;
	offset = 0x2000 * (y%2) + 80 * (y/2) + x/4;
        mask = peekb(0xB800,offset);
	color = mask >> (6 - (x%4)*2) & 0x03;
	return (color);
}

main()
{
	setvect(5, print_handler);
	printf("\nEGA Graphic Screen Printing Routine Installed\n");
	keep(0,0x9FF);
}
