               /*Ŀ
                                                                        
                    prntinst = installs graphics print screen routine   
                               to replace the original print screen     
                               routine.                                 
                                                                        
                 */

#include <dos.h>


void interrupt print_handler()
{
	unsigned char background;
        int i,x;

	void put_out(char character);

	put_out(0x1b);
	put_out(0x33);
	put_out(0x15);
        for (i=0; i<12; i++)
		put_out(0x0A);
        background = readPixel(0,0);
	for (x=639; x>=7; x-=8)
	{
        	printrow(x,background);
        }
        put_out('\x0C');
}

printrow(int x,int background)
{
	unsigned char savechar,temp;
        unsigned char out_buff[434]={"\x1bK\xAE\x01"};
	int i, j, newy,y;

	char status();
	void put_out();

	for (y=0,j=84; y<=349; y++,j++)
	{
		savechar = 0;
		for (i=0; i<8; i++)
		{
			temp = readPixel(x-i,y);
			if (temp != background)
				savechar |= 1;
			if (i!=7)
				savechar <<= 1;
		}
		out_buff[j] = savechar;
	 }
	for (i=0; i<434; i++)
	{
		put_out(out_buff[i]);
	}
	put_out('\r');
	put_out('\n');
}

char status()
{
	char temp;
	temp = inportb(0x379);
	return (temp & 0x80);
}


void put_out(char character)
{
	int temp;
	
	while (!status());
	outportb(0x378,character);
	outportb(0x37A,0x0D);
	outportb(0x37A,0x0C);
}


int readPixel (int x, int y)
{	
	#define DISPLAY_OUT(index,val)  {outp(0x3CE,index);\
					 outp(0x3CF,val);}		
	int i,j,color=0;
	unsigned char mask, exist_color;
	char far *base;
	base = (char far *) (0xA0000000L + ((long)y * 80L + ((long)x/8L)));
	mask = 0x80 >> (x % 8);			
	for (i=0; i<4; i++)
	{	DISPLAY_OUT(4,i);
		DISPLAY_OUT(5,0);
		exist_color = *base & mask;		
		if (exist_color != 0)
			color |= 0x01<<i;
	}
	return color;
}

main()
{
	setvect(5, print_handler);
	printf("\nEGA Graphic Screen Printing Routine Installed\n");
	keep(0,0x9FF);
}




