// *************************************************************** //
// Filename:    MenuTest.cpp                                        //
//                                                                 //
// Date:        July 14, 1993                                      //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "MenuTest.h"

const int MaxBufferSize = 128;
const int EndOfMenu = -1;
const int PopupMenuItemId = -1;

TTrackPopupMenu::TTrackPopupMenu(TMenu &menu) :
  TPopupMenu()
{
  int currentMenuIndex = 0;
  UINT menuItemId;
  UINT menuItemState;
  HMENU hSubMenu;
  char buffer[MaxBufferSize];

  while ((menuItemState = 
    menu.GetMenuState(currentMenuIndex, MF_BYPOSITION)) != EndOfMenu)
  {
    if (menuItemState != EndOfMenu)
    {
      menu.GetMenuString(currentMenuIndex, buffer, MaxBufferSize, MF_BYPOSITION);
      menuItemId = menu.GetMenuItemID(currentMenuIndex);
      if (menuItemId == PopupMenuItemId)
      {
        hSubMenu = menu.GetSubMenu(currentMenuIndex);
        AppendMenu(LOBYTE(menuItemState), (UINT)hSubMenu, buffer);
      }
      else
      {
        AppendMenu(LOBYTE(menuItemState), menuItemId, buffer);
      }
      currentMenuIndex++;
    }
  }
}

// --------------------------------------------------------------- //
// MenuTestWindow constructor                                       //
// --------------------------------------------------------------- //
TMenuTestWindow::TMenuTestWindow() :
  TWindow(0, 0, 0)
{
  Menu = new TMenu(*GetApplication(), MainMenu);
  PopupMenu = new TTrackPopupMenu(*Menu);
}

// --------------------------------------------------------------- //
// MenuTestWindow destructor                                        //
// --------------------------------------------------------------- //
TMenuTestWindow::~TMenuTestWindow()
{
  delete PopupMenu;
  delete Menu;
}

// --------------------------------------------------------------- //
// GetClassName                                                    //
// --------------------------------------------------------------- //
char *TMenuTestWindow::GetClassName()
{
  return "MenuTestClass";
}

// --------------------------------------------------------------- //
// GetWindowClass                                                  //
// --------------------------------------------------------------- //
void TMenuTestWindow::GetWindowClass(WNDCLASS &wc)
{
  TWindow::GetWindowClass(wc);
  wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
}

// --------------------------------------------------------------- //
// SetupWindow                                                     //
// --------------------------------------------------------------- //
void TMenuTestWindow::SetupWindow()
{
  TWindow::SetupWindow();
  // put new stuff here
}

// --------------------------------------------------------------- //
// CleanupWindow                                                   //
// --------------------------------------------------------------- //
void TMenuTestWindow::CleanupWindow()
{
  // put new stuff here
  TWindow::CleanupWindow();
}

// --------------------------------------------------------------- //
// Response table for MenuTestWindow                                //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TMenuTestWindow, TWindow)
  EV_COMMAND(CM_ITEM1, CmItem1),
  EV_COMMAND(CM_ITEM2, CmItem2),
  EV_COMMAND(CM_ITEM3, CmItem3),
  EV_WM_RBUTTONDOWN,
END_RESPONSE_TABLE;

void TMenuTestWindow::CmItem1()
{
  MessageBox("Item1", "Status", MB_OK);
}

void TMenuTestWindow::CmItem2()
{
  MessageBox("Item2", "Status", MB_OK);
}

void TMenuTestWindow::CmItem3()
{
  MessageBox("Item3", "Status", MB_OK);
}

void TMenuTestWindow::EvRButtonDown(UINT modKeys, TPoint& point)
{
  if (PopupMenu)
  {
    ClientToScreen(point);
    PopupMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
      point, 0, HWindow, NULL);
  }
}
