// *************************************************************** //
// Filename:    MenuTest.h                                          //
//                                                                 //
// Date:        July 14, 1993                                      //
//                                                                 //
// Description:                                                    //
// *************************************************************** //

#ifndef MenuTest_H
#define MenuTest_H

#include <owl\applicat.h>
#include <owl\framewin.h>
#include <owl\gdiobjec.h>
#include <owl\menu.h>
#include <owl\dc.h>
#pragma hdrstop
#include "MenuTest.rh"

extern char *MainMenu;

// --------------------------------------------------------------- //
// MenuTestApplication                                              //
// --------------------------------------------------------------- //
class TMenuTestApp : public TApplication 
{
public:
  TMenuTestApp();
 ~TMenuTestApp();
  void InitMainWindow();
};

// --------------------------------------------------------------- //
// TTrackPopupMenu                                                 //
// --------------------------------------------------------------- //
class TTrackPopupMenu : public TPopupMenu
{
  public:
    TTrackPopupMenu(TMenu &menu);
};


// --------------------------------------------------------------- //
// MenuTestWindow                                                   //
// --------------------------------------------------------------- //
class TMenuTestWindow : public TWindow 
{
protected:
  TMenu *Menu;
  TTrackPopupMenu *PopupMenu;
  void EvRButtonDown(UINT modKeys, TPoint& point);
  void CmItem1();
  void CmItem2();
  void CmItem3();
public:
  TMenuTestWindow();
 ~TMenuTestWindow();

  void GetWindowClass(WNDCLASS& wndClass);
  char *GetClassName();
  void SetupWindow();
  void CleanupWindow();
  
  DECLARE_RESPONSE_TABLE(TMenuTestWindow);
};

#endif


