/*****************************************************************
      TINY CLOCK -- INITIALIZATION/DISPOSABLE CODE
       Copyright (c) 1992-94 by Omega Point, Inc.
******************************************************************/
#include "cr.h"

#ifdef K1		/** Use LIM if PDK-1 is available */
#include "lm.h"
#endif

#define STK_SZ (64)		/* TSR Stack: 64 words */
word isr_stk[STK_SZ+1];


extern popclock();	/* Main TSR entry, called by scheduler */

/******** Disposable messages in CLOCKID.C **************/

extern char sms[]; 	     /* Signon screen		         */
extern char attrc[],attrm[]; /* Screen attributes used for signon */
extern char already[];       /* Message when already loaded 	 */
extern char unloaddone[];
extern char unloadnot[];
extern word init_data_end;   /* Marker for end of disposable data */


/********************************************************************
 This main gets called only once on program load, after that it is
 discarded 
*********************************************************************/

main()
{  int i;
   char *a;
   
     if (second_load())	/* Check if TSR already loaded */
       {
       i=str_pos('-',cmd_line);
       if (i && ((cmd_line[i]|0x20)=='r'))
         {
	 if(remove_tsr())		/* Remove TSR from memory */
	   dspf(unloaddone);		/* Inform about unloading */
	 else
	   dspf(unloadnot);
	 }
       else dspf(already);		/* Otherwise show Help message */
       mv_crs();			/* Reposition real cursor */
       return(1);			/* Exit with errorlevel 1 */
       }

 /***** Display Signon Screen *****/

     clr_scr();
     a = color ? attrc:attrm;	/* Select proper screen attributes */
     crs_x=20; crs_y=7;		/* Location to put signon box      */
     dspf(sms,a);		/* Show the screen                 */

     crs_x=0; crs_y=scr_len-2;	/* Move to the bottom of screen    */
     mv_crs();			/* Place real cursor there         */
     crs_y=0;			/* Top line used to display clock  */


#ifdef DBG   /********** Debug mode via -DDBG compiler switch ***********/

     popclock();	/* The TSR can be debugged as a regular program */

#else	     /**********  INIT TSR MODE  ********************************/

     idata_end=&init_data_end;		/* This enables init data disposal. */
     icode_beg=main;			/* This enables init code disposal. */
     stay_resident(isr_stk,STK_SZ*2);	/* Enable resident mode             */
     install_tsc(popclock,2*STK_SZ,1);	/* Install tiny scheduler           */
#ifdef K1				/* Usable only with PDK1            */
     move_to_lim(1,1,MOVE_BOTH);	/* Move TSR to LIM if available     */
#endif
     add_tsc_event(8L);    	/* Add event to timer, 8 ticks from now  */
				/* Popclock will be called by scheduler  */
     return(0);			/* Set errorlevel to 0                   */

#endif
}
