/***************************************************************
        TINY CLOCK - TSR (RESIDENT) MODULE
    Copyright (c) 1992-94 by Omega Point, Inc.
****************************************************************/

#include "cr.h"

char time_str[]="00:00:00";

popclock(void)
{  register char *t,*s;
   struct time_rec cur_time;

	add_tsc_event(6L);	/* Setup next event in 1/3 second */

	bios_time(&cur_time);	/* Read BIOS time of day */

	t=&cur_time.hours;	/* Prepare to convert hh:mm:ss */
	s=time_str;
	do cv_b2dec((byte)*t,s), s+=3;     /* Convert 1 byte to decimal */
	  while (--t>=&cur_time.seconds);  /* Until done with seconds */

	chk_video();		  /* Obtain current video settings */
	crs_x=scr_width-8;	  /* Set cursor to upper right corner */
	dsp(time_str);		  /* Display time string there */

}
