/********************************************************************
        PopASC  (c) Copyright 1992-94 by Omega Point, Inc.
*********************************************************************/

#include "cr.h"

#ifdef K1		/* EMS support to create ASCEMS.EXE */
#include "lm.h"		/* which allows move_to_lim() feature */
#endif

/****************************************************************************
		INITIALIZATION CODE - main()
*****************************************************************************

This module contains initialization code for the resident program.
It is not linked as OBJ file but rather as a library file in order to
assure it gets placed at the end of code segment. No other permanent
code should be written inside this module (like isr()).
Dummy function label init_code_beg marks the start of init code.
Similar data marker init_data_end is declared in the first user C-module 
ASCID.C and is called init_data_end.

In order to ENABLE data/code space COMPACTION before going resident
main() should place addresses of these markers into predefined variables
icode_beg,idata_end. The Runtime R0/R1.OBJ will then discard code/data
items used only on initialization. Either of the two code/data compactions
may be enabled separately.

***************************************************************************/



/** STARTUP DATA are in ASCID.C  (discarded in resident mode) **/

extern char loaded_msg[],hello_msg[]; /* Startup messages */
extern char removed_msg[],cant_msg[];
extern char hello_atr[];

extern word init_data_end;	      /* Marks end of init-data */


/** RESIDENT CODE STACK SPACE **/

#define STK_SZ (100)	  /* Size in words */
word res_stack[STK_SZ+1]; /* Allow allways extra word ! */

extern isr();		/* Interrupt service in ASC.C */
extern word hk_list[];  /* This is in ASC.C for use by isr() function */


/** Display Signon screen **/

signon()
{
  int x0,y0,dx,dy;
   vid_atr=7; clr_scr();
   x0=crs_x=10; y0=crs_y=3;
     dspf(hello_msg,hello_atr);
   dx=crs_x-x0+2; dy=crs_y-y0+3;
   crs_x=x0-1; crs_y=y0-1;
     dsp_box(dx,dy,0x103);
   crs_x=0; crs_y=22; 
     mv_crs();
   vid_atr=0x7;
}


main()
{ char *s=cmd_line;

  signon();
  if (second_load()) 		/* Check if program already loaded */
    {
    up_case(s);	/* Convert command line to upper case */
    if (str_pos('U',s))		/* Command line /U to unload TSR */
      {
      if (remove_tsr())		/* Remove it from memory */
        dspf(removed_msg);	/* Removed Ok */
      else dspf(cant_msg);	/* Cannot remove (not last TSR) */
      }
    else
      dspf(loaded_msg);	/* If so, display error message (in ASCID.C) */
    	
    return(1);		/* Exit to DOS with errorlevel 1 */
    }

 /* SWITCH TO RESIDENT OPERATION */

  idata_end=&init_data_end;	/* This enables init data disposal. */
  icode_beg=signon;		/* This enables init code disposal. */

  stay_resident(res_stack,STK_SZ*2);	/* Define TSR stack */
  install_hk(hk_list,isr,STK_SZ*2,3);	/* Install HOT-KEY Support */


#ifdef K1			/* LIM support for PDK-1 users */
  move_to_lim(1,1,MOVE_BOTH);	/* Moves TSR to EMS if available */
#endif
  return(0);				/* Exit code 0=Ok exit */

}
