/*****************************************************************************
* General, local to module, definitions of View Object module.		     *
*****************************************************************************/

#ifndef	VIEW_OBJ_LH
#define	VIEW_OBJ_LH

/* Interactive menu setup structure: */
#define INTERACT_NUM_OF_STRINGS 3
#define INTERACT_NUM_OF_SUB_WINDOWS 16
#define INTERACT_SUB_WINDOW_HEIGHT 0.04	      /* Actually half Height/Width. */
#define INTERACT_SUB_WINDOW_WIDTH  0.3

#define MAX_ROTATE_ANGLE	45.0 /* Max. rates used by interactive mode. */
#define MAX_TRANSLATE_FACTOR	2.0
#define MAX_SCALE_FACTOR	2.0
#define MAX_PERSP_FACTOR	2.0
#define PERSPECTIVE_DEFAULT	-5

typedef struct InteractString {
    double X, Y;
    int Color;
    char *Str;
} InteractString;
typedef struct InteractSubWindow {
    double X, Y;					   /* Center points. */
    int Color,
	TextInside; /* If TRUE, Str will be in window, otherwise left to it. */
    char *Str;
} InteractSubWindow;
typedef struct InteractWindowStruct {	 /* The interactive menu structures. */
    /* Rotate, Translate, Scale strings: */
    InteractString Strings[INTERACT_NUM_OF_STRINGS];
    InteractSubWindow SubWindows[INTERACT_NUM_OF_SUB_WINDOWS];
} InteractWindowStruct;

/* Prototypes for the View Object module: */
static void InteractDrawMenu(void);
static void InteractHandleInput(FileDescription **FD, int NumOfObj,
							char **Objects);
static void InteractUpdateMenu(char *Str, int Entry);
static void ViewGeomObjectList(FileDescription **FD, int NumOfObjects,
							char **Objects);
static void SaveCurrentMat(void);
static ObjectStruct *SearchObject(FileDescription **FD, char *Object);
static void DrawAllObjects(FileDescription **FD);
static void VisitObjectTree(BinTree *PBinTree);
static void ViewOneObject(ObjectStruct *PObject);
static void ViewOnePolygon(PolygonStruct *PPolygon);
static void MyMoveTo(float Coord[3]);
static void MyDrawTo(float Coord[3]);
static void SetDrawColor(int Color);
static void TestQuitView(void);

#endif	VIEW_OBJ_LH
