/*****************************************************************************
* Definitions for the Poly3D program:					     *
*****************************************************************************/

#ifndef POLY_3D_H
#define POLY_3D_H

#ifdef NO_VOID_PTR
#define VoidPtr		char *
#else
#define VoidPtr		void *
#endif /* NO_VOID_PTR */

#define RealType double

#include "genmat.h"
#include "parser.h"

#ifndef __MSDOS__
#include "xgeneral.h"
#endif /* __MSDOS__ */

#ifndef	NULL
#define	NULL	0
#endif

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#ifndef LINE_LEN
#define LINE_LEN	255
#endif

#define FILE_NAME_LEN	80

/* Name	of generic matric transformation saved by this program:	*/
#define GENERIC_MAT_FILE  "generic#.mat"   /* Generic mat file name to save. */
#define GENERIC_GIF_FILE  "generic#.gif"   /* Generic gif file name to save. */
#define GENERIC_PS_FILE   "generic#.ps"	    /* Generic PS file name to save. */

/* The current NormalLength is divided by scaler to form real normal length: */
#define NORMAL_DEFAULT_LENGTH	10
#define NORMAL_SCALER_LENGTH	100

#define ABS(y)		((y) > 0 ? (y) : (-(y)))
#define SQR(y)		((y) * (y))
#define SGN(x)		((x) > 0 ? 1 : ((x) == 0 ? 0 : -1))
#define MIN(x, y)	((x) > (y) ? (y) : (x))
#define MAX(x, y)	((x) > (y) ? (x) : (y))
#define BOUND(x, Min, Max) (MIN(MAX((x), (Min)), (Max)))
#define GEN_COPY(Dest, Src, Size)       memcpy(Dest, Src, Size)

#define INFINITY	1e6
#define EPSILON		1e-6

#define DEG2RAD(Deg)	((Deg) * M_PI / 180.0)
#define RAD2DEG(Rad)	((Rad) * 180.0 / M_PI)

#define BSPACE	8
#define TAB	9
#define LF	10
#define CR	13
#define ESC	27

#define DEFAULT_COLOR		1      /* For objects with no color defined. */

#define VIEW_PERSPECTIVE	1			      /* View modes. */
#define VIEW_ORTHOGRAPHIC	2
#define DEFAULT_PERSPECTIVE_Z	-5.0		   /* Default Z focal point. */

#define TRANS_SCREEN	1     /* Screen, Object coords. transformation mode. */
#define TRANS_OBJECT	2

/* Some external variables defined for all the programs: */

extern int InterFlag, MoreFlag, TextFlag, DrawVNormalsFlag, DrawPNormalsFlag,
	   NumEdges, MouseExists, GraphDriver, ClosedObject;

extern MatrixType GlblViewMat, GlblPerspMat;/* Current view/persp. of object.*/
extern MatrixType CrntViewMat;			/* This is the current view! */
extern int GlblTransformMode;	      /* Screen, Object coords. trans. mode. */
extern int GlblViewMode;		   /* Perspective, Orthographic etc. */
extern int GlblDepthCue;			   /* Activate depth cueing. */
extern int GlblNormalLen;		     /* Scaler for normals if drawn. */

/* And finally Poly3D module prototypes: */

char *MyMalloc(unsigned size);
void MyExit(int ExitCode);

#endif POLY_3D_H
