/*****************************************************************************
* General definitions of/for GenMat.c module				     *
*****************************************************************************/

#ifndef	GEN_MAT_H
#define GEN_MAT_H

typedef double MatrixType[4][4];

#ifndef INFINITY
#define INFINITY 1e6
#endif  INFINITY

/* And prototypes of the functions: */

void GenUnitMat(MatrixType Mat);
void GenMatTrans(double Tx, double Ty, double Tz, MatrixType Mat);
void GenMatScale(double Sx, double Sy, double Sz, MatrixType Mat);
void GenMatRotX1(double Teta, MatrixType Mat);
void GenMatRotX(double CosTeta, double SinTeta, MatrixType Mat);
void GenMatRotY1(double Teta, MatrixType Mat);
void GenMatRotY(double CosTeta, double SinTeta, MatrixType Mat);
void GenMatRotZ1(double Teta, MatrixType Mat);
void GenMatRotZ(double CosTeta, double SinTeta, MatrixType Mat);

void MultTwo4by4(MatrixType MatRes, MatrixType Mat1, MatrixType Mat2);

void MultVecby4by4(double VRes[3], float Vec[3], MatrixType Mat);

#endif GEN_MAT_H
