/*****************************************************************************
* Definitions for the Poly3D-H program:                                      *
*****************************************************************************/

#ifndef POLY_3D_H_H
#define POLY_3D_H_H

#ifdef NO_VOID_PTR
#define VoidPtr		char *
#else
#define VoidPtr		void *
#endif /* NO_VOID_PTR */

#include "genmat.h"
#include "parser.h"

#ifndef __MSDOS__
#include "xgeneral.h"
#endif /* __MSDOS__ */

#ifndef LINE_LEN
#define LINE_LEN	255
#endif  LINE_LEN

#define FILE_NAME_LEN	80

#ifndef NULL
#define NULL	0
#endif

#ifndef TRUE
#define TRUE	-1
#define FALSE	0
#endif

#define EPSILON	1e-4  /* Make it smaller if you changed to double precision. */

#define TEXT_FILE_OUTPUT 1  /* Kind of output - text file or graphic-screen. */
#define GRAPHICS_OUTPUT  2

#define  EDGE_HASH_TABLE_SIZE	500 /* Number of entries in edge hash table. */
#define  EDGE_HASH_TABLE_SIZE1	499		     /* One below the above. */
#define  EDGE_HASH_TABLE_SIZE2	250			   /* Half of above. */
#define  POLY_HASH_TABLE_SIZE	500 /* Number of entries in poly hash table. */
#define  POLY_HASH_TABLE_SIZE1	499		     /* One below the above. */
#define  POLY_HASH_TABLE_SIZE2	250			   /* Half of above. */

#define  DEFAULT_COLOR		1	       /* In case no color is given. */

#define  VIEW_PERSPECTIVE	1			      /* View modes. */
#define  VIEW_ORTHOGRAPHIC	2
#define  DEFAULT_PERSPECTIVE_Z	-5.0		   /* Default Z focal point. */

#define  HIDDEN_COLOR	CYAN	        /* Color to draw hidden line result. */

/* General macro definitions for evry day usage...  */

#define ABS(y)		((y) > 0 ? (y) : (-(y)))
#define SQR(y)		((y) * (y))
#define SGN(x)		((x) > 0 ? 1 : ((x) == 0 ? 0 : -1))
#define MIN(x, y)	((x) > (y) ? (y) : (x))
#define MAX(x, y)	((x) > (y) ? (x) : (y))
#define BOUND(x, Min, Max) (MIN(MAX((x), (Min)), (Max)))
#define APX_EQ(x, y)	(ABS(x - y) < EPSILON)

#define GEN_COPY(Dest, Src, Size)       memcpy(Dest, Src, Size)

#define DEG2RAD(Deg)	((Deg) * M_PI / 180.0)
#define RAD2DEG(Rad)	((Rad) * 180.0 / M_PI)

/* The following are global setable variables (via config file poly3d-h.cfg) */
extern int MoreFlag, NumEdges, ViewFlag, BackFacingFlag, InternalFlag;

extern int NumOfPolygons;	      /* Total number of polygons to handle. */

/* Global transformation matrix: */
extern MatrixType GlblViewMat;		   /* Current view/persp. of object. */

/* Data structures used by the hidden line modules: */
extern int EdgeCount;
extern struct EdgeStruct *EdgeHashTable[];
extern struct PolygonStruct *PolyHashTable[];

/* And finally the prototypes of the Poly3D-H.c module: */
char *MyMalloc(unsigned size);
void MyExit(int ExitCode);

/* Prototypes of the PrepData.c module: */
void PrepareViewData(FileDescription **FD, int NumOfObjects, char **Objects);
int CrossProd(float Pt1[3], float Pt2[3], float Pt3[3]);

/* Prototypes of the Out-Edge.c module: */
void OutVisibleEdges(void);

#endif POLY_3D_H_H
