/*****************************************************************************
* General definitions goes here:                                             *
*****************************************************************************/

#ifndef PARSER_H
#define PARSER_H

#ifndef LINE_LEN
#define LINE_LEN	255
#endif  LINE_LEN

#define NAME_LEN	6

#ifndef TRUE
#define TRUE		-1
#define FALSE		0
#endif

#ifndef NULL
#define NULL		0
#endif

#define FILE_TYPE_DATA  1
#define FILE_TYPE_VIEW  2

#define	UNGET_STACK_SIZE 5

/*****************************************************************************
* Tokens definitions goes into here                                          *
*****************************************************************************/
#define TOKEN_OPEN_PAREN     1
#define TOKEN_CLOSE_PAREN    2

#define TOKEN_NUMBER        10     /* Not used as number & names are decoded */
				    /* according to their places in grammer. */
#define TOKEN_VERTEX        20
#define TOKEN_POLYGON       21
#define TOKEN_POLYLINE      22
#define TOKEN_OBJECT        23
#define TOKEN_COLOR         24
#define TOKEN_INTERNAL      25
#define TOKEN_PLANE         26

#define TOKEN_OTHER         100			/* Probably names & numbers. */
#define TOKEN_EOF           -1

#define VERTEX_ENTRY        0x0001	      /* Entry type, up to 16 types. */
#define POLYGON_ENTRY       0x0002
#define POLYLINE_ENTRY      0x0004
#define OBJECT_ENTRY        0x0008
#define COLOR_ENTRY         0x0010

/*****************************************************************************
* Parser error codes are following:                                          *
*****************************************************************************/
#define P_ERR_NumberExpected		1
#define P_ERR_CloseParanExpected	2
#define P_ERR_ListCompUndef		3
#define P_ERR_UndefExprHeader		4

/*****************************************************************************
* And some more definitions ...                                              *
*****************************************************************************/

typedef unsigned char Byte;

typedef struct BinTree {	   /* The entries are saved as binary trees. */
    struct BinTree *right, *left;		      /* Classic, isnt it !? */
    union {
	VoidPtr		      PVoid;
	struct VertexStruct  *PVertex;
	struct PolygonStruct *PPolygon;
	struct PolygonStruct *PPolyline;
	struct ObjectStruct  *PObject;
    } Data;
    char Name[NAME_LEN];
    Byte EntryType;				/* Kind of pointer in union. */
    Byte Used;	     /* TRUE if allready has been used (multi - referenced). */
} BinTree;

typedef struct FileDescription {  /* Each data file loaded gets such struct. */
    BinTree *VertexPointer,	         /* Pointers on the binary trees ... */
	    *PolygonPointer,
	    *PolylinePointer,
	    *ObjectPointer;
} FileDescription;

/* Use the following structure if linear list operations are to be performed */
/* on VertexStruct/PolygonStruct/ObjectStruct (Virtual functions...).	     */
typedef struct LinearListStruct {
    struct LinearListStruct *Pnext;
} LinearListStruct;

typedef struct VertexStruct {
    struct VertexStruct *Pnext;
    float Coord[3];					   /* The 3D coords. */
    Byte Transform;
    Byte Internal;		       /* If edge is Internal (IRIT output). */
} VertexStruct;

typedef struct EdgeStruct {
    struct VertexStruct *Vertex[2];		   /* The two edge vertices. */
    struct EdgeStruct *Pnext;
    Byte Internal;		       /* If edge is Internal (IRIT output). */
} EdgeStruct;

typedef struct PolygonStruct {
    struct PolygonStruct *Pnext;
    VertexStruct *PVertex;			    /* The polygon vertices. */
    float Xmin, Xmax, Ymin, Ymax;	     /* Bounding box of the polygon. */
    float Plane[4];		         /* Plane equation of polygon plane. */
    Byte Polyline;
} PolygonStruct;

typedef struct ObjectStruct {
    struct ObjectStruct *Pnext;
    int Color;				    /* optionally if Color was def.. */
    PolygonStruct *PPolygon;			    /* The objects polygons. */
} ObjectStruct;

/* And function prototypes: */

FileDescription *GetDataFile(FILE *f);
void GetViewFile(FILE *f, int FileExists);
BinTree *GetBinTree(char *RecName, BinTree *Tree);

#endif PARSER_H
