

//---------------------------TEST.CPP--------------------------------------//
// author: Daniel W. Moore
//
// A 'workout' for the virtual objects
//

#include <iostream.h>
#include <conio.h>
#include <stdlib.h>

#include "vobj.h"

#define _DEBUGHEAP_ 0  // change to '1' for an inspectable HeapArray object

///#define RAMDISK_FILENAME "G:\\DISK.MEM"


#if _DEBUGHEAP_

HeapArray D(100000L);

#define ASIZE 500
#define NOBJ 50
VMemory AVMem(&D,200,480);

#elif _EMS_
			  // to use with DOS 5.0 or 6.0 EMS, put the line
EMSArray D(1024*1024L);   //       DEVICE=c:\DOS\EMM386.EXE 1280 RAM
#define ASIZE 500           // in your CONFIG.SYS
#define NOBJ 500
VMemory AVMem(&D,2000,480);

#else

 #ifdef RAMDISK_FILENAME
   DiskArray D(1024*1024L, RAMDISK_FILENAME); // need 1-Meg ramdisk
 #else
   DiskArray D(1024*1024L); // use default filename DISKARRY.000
 #endif

#define ASIZE 500  // make each virtual object about 2K long!
#define NOBJ 500
VMemory AVMem(&D,2000,480);

#endif

class MyObject;

//  want to store objects of type 'MyObject' in the virtual memory

class MyObject: public VObject
{
  static recurs;
  int j;
  long arr[ASIZE];    // array increases object's size
public:
  MyObject (int y=0);
  operator int() { return  j; }
  VPtrBase ptr;
  float times ();
  ~MyObject();
  long& operator[] (size_t i) {
    return arr[i];
  }
};


declare(VPtr,MyObject);

MyObject::~MyObject() {
  cout << '~' << (int)(*this) << ' ';
  for (int i=0; i<ASIZE; i++) arr[i]=0;
}

MyObject::MyObject (int y) {
  j=y;
  for (int i=0; i<ASIZE; i++) arr[i]=(long)i*j;
}


int MyObject::recurs = 0;   // recursion counter

float MyObject::times ()    // sample recursive method for MyObject
{
  float j, thisval = (int)(*this) ;
  cout << thisval;
  if (ptr && recurs<5) {
    recurs++;
    Lock(this);
    cout << " * ";
    float j = thisval * ((VPtr(MyObject)&)ptr)->times(); // call myself recursively
    Unlock(this);
    recurs--;
    return j;
  } else  {
    return thisval;
  }
}

pause()
{
   cout << "\n" << "Hit any key to continue" << "\n";
   getch();
   return 0;
}

//---- static pointer array: starts out full of NULL ----

static VPtr(MyObject) huge p [NOBJ];

main()
{
 int i,j;
 if (!AVMem) return 0; // check for valid virt. memory object

 VPtr(MyObject) p0;
 if (!p0) {
    p0 = new MyObject;
 }
 VPtr(MyObject) tempMyObject = new MyObject;

 tempMyObject = new MyObject(90);
 MyObject* realpointer = tempMyObject.Lock();
 cout << "\n" << "Locking object with value " << (int)*tempMyObject << "\n";

 cout << "\n" << "Creating objects of size " << sizeof(MyObject)
  << " ... " << "\n";

 for (i=0; i<NOBJ; i++) {
   p[i] = new MyObject (i);
   if (!p[i])
   {
     cout << "* ";
     continue;
   }
   if (i>1) p[i]->ptr = p[i-1]; // internal link to last object
   cout << i << " ";
 }
 cout << "\n"
      << "locked object still contains " << (int)*realpointer << "\n";
 tempMyObject.Unlock();

		pause();

 cout << "\n" << "Testing recursion for 30 iterations ..." << "\n";

 for (i=1; i<NOBJ; i++) {
   if (!p[i] || i>30) break;
   float product = 
      p[i]->times();      // call recursive method
   cout << " = " << product << "\n";
 }

 AVMem.flush(); // empty the LRU object cache (just for demo)

		pause();

 cout << "\nDeleting even-numbered objects...\n" ;
 for (i=0; i<=NOBJ-2; i+=2)  {
   Delete( p[i] );
   p[i]=NULL;
 }

		pause();

 cout << "\nRecreating them backwards...\n";
 for (i=0; i<=NOBJ-2; i+=2)
 {
   p[i]=new MyObject(NOBJ-i);
   if (p[i]) {
     cout <<  int( *p[i] )  << " ";
   } else break;
 }

		pause();

 cout << "\nObjects are now numbered:\n";
 for (i=0; i<NOBJ; i++) {
   if ( p[i] ) {
     cout << int(*(p[i])) << ' ';
   } else {
     cout << "* ";
   }
 }

 cout << "\n\nNow we'll test MyObject's internal method calls.";
 cout << "\nOnce started, you can any key to stop ... \n";

		pause();

 srand(12345);
 while (!kbhit()) {
  long a = NOBJ*((long)rand()-1)/RAND_MAX;
  long b = ASIZE*((long)rand()-1)/RAND_MAX;
  if (p[a]) {
   cout << "\nChecking " << a << "*" << b ;
   MyObject& OB = *(p[a].Lock());
   long A = (int) OB;
   if (A*b != OB[b]) {
     cout << " -- FAILURE -- " ; break;
   }
   else 
   {
     cout << " (passed) ";
   }
   p[a].Unlock();
  }
 }
 getch();
 return 0;
}

