
//-------------------- (Figure 3) EX2.CPP --------------------
// author: Daniel W. Moore
// Example 2 to be used with PMDE
//

#include "vobj.h"
#include <iostream.h>
#include <generic.h>

#define LARGENUM 80000L  // must have 320K of core free to run this!!
                         // recommend use of RAMDISK or SMARTDRV, as well ...

DiskArray D(1024L*1024);    // use 1-meg disk file for swap space
VMemory AVMem(&D,480,2048); // array will have at most 480 possible handles
                            // (objects), with 2k bytes per allocation unit
                            // feel free to increase filesize & handles parm.

VHANDLE huge handle [ LARGENUM ];

class MyObject : public VObject {
  public:
  ////////// char a[1800]; // : optional large array!
  int k;
  MyObject( long j ) {
    k=j;
  }
};
declare (VPtr,MyObject);

main()
{
  VHANDLE hnd;
  VPtr(MyObject) p;
  cout << "\n Creating: ";

  for (long i=0; i<LARGENUM; i++) {        // create objects
    handle[i]  = p = new MyObject(i);   // use pointer-to-long conversion
    if (!handle[i]) break;              // did we run out of virtual memory?
    cout << i << " ";
  }

  cout << "\n Recalling: ";
  for (i=0; i<LARGENUM; i++) {             // cycle through objects
    if ( (hnd = handle[i]) == 0 ) break;
    p = hnd;                            // use handle-to-pointer constructor
    cout << p->k << " ";
  }
  return 0;
}

