
//-------------------- (Figure 1) EX1.CPP --------------------
// author: Daniel W. Moore
//
// Example1 to be used with PMDE
//

#include "VObj.h"
#include <generic.h>
#include <iostream.h>

DiskArray D(500000L);
VMemory AVMem( &D, 1024, 256 );  // 1024 blocks of 256 bytes each

class MyObject: public VObject {
  public:
    long k;
    MyObject( long j ) { k = j; }
    ~MyObject( ) { cout << "deleting object\n" ; k = 0; }
};

class YourObject: public MyObject {
  public:
    long m;
    YourObject(long j ): MyObject(j) { m=2*k; }
};

// declare a special pointer type derived from the generic VPtrBase,
// for accessing MyObject members

declare(VPtr,MyObject);
declare(VPtr,YourObject);

void store_six ( VPtr(MyObject) p )
{
  p->k=6;
}

main()
{          
  VPtr(MyObject)  PMyObject = new MyObject( 5 );
  cout <<  "object contains " << PMyObject->k << "\n";
  VPtr(MyObject) a;
  VPtr(MyObject) b=PMyObject;
  a=b;
  store_six(a);
  cout <<  " now contains " << (*PMyObject).k << "\n";
  Delete( PMyObject );
  VPtr(YourObject) PYourObject = new YourObject(2);
  cout <<  "New object contains twice 2 = " << PYourObject->m << "\n";
  return 0;
}


