/* - Some support routines to harness DOS' expanded memory services - */

#include <dos.h>
#include <string.h>

#define EMS_INTPT (0x67)
#define EMS_FAIL (-1)
typedef unsigned char Byte;
typedef unsigned int Word;

#define FARP(segm, offs) ((void far *) ((long) (segm) << 16 | (offs) ))

char *emm_devname="EMMXXXX0";

int EMSinstall()
{
  struct SREGS sR;
  union REGS R;
  R.h.al=0x67;
  R.h.ah=0x35;
  intdosx(&R, &R, &sR);
  return !memcmp( FARP(sR.es, 10), emm_devname, strlen(emm_devname));
}

int EMSalloc(int n)
{
  union REGS R;
  R.h.ah = 0x43;
  R.x.bx = n;
  int86(EMS_INTPT, &R, &R);
  if (R.h.ah)
    return(EMS_FAIL);
  return( R.x.dx );
}


int EMSfree(int handle)
{
  union REGS R;
  R.h.ah = 0x45;
  R.x.dx = handle;
  int86(EMS_INTPT, &R, &R);
  return (!R.h.ah);
}

Word EMSframe()
{
  union REGS R;
  R.h.ah = 0x41;
  int86(EMS_INTPT, &R, &R);
  
  if (R.h.ah)
    return(EMS_FAIL);
  else
    return( R.x.bx );
}

int EMSmap(int handle, int log, Byte phys)
{
  union REGS R;
  R.h.ah = 0x44;
  R.h.al = phys;
  R.x.bx = log;
  R.x.dx = handle;
  int86(EMS_INTPT, &R, &R);
  return (!R.h.ah);
}
